/********************************************************************************/
/*	beaglebone black rev.C	TAB=4												*/
/*	OS Debian Stretch 9.5 LXQT													*/
/*		Linux version 4.14.67-ti-r73 											*/
/*		gcc version 6.3.0 20170516												*/
/*																				*/
/*  adf4351.c 																	*/
/*  Copy Right(C) 2018- by Hiroaki Ikeda										*/
/*	PLL ADF4351 TEST PROGRAM													*/
/*																				*/
/*	using LIB BBCLib															*/
/********************************************************************************/
#include <stdio.h>
#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/types.h>
#include "../BBBIOlib-master/BBBio_lib/BBBiolib.h"

#define DEBUG_SW	1
#define ADF4351_LE	9,41	//header9 41pin(GPIO0_20)
#define LOW			0
#define HIGH		1

/* 		  -----0------              -----0------
		  +-------+ +---------+ +-------+ +----------------+   +-----------+
	REFin |DOUBLER| |R COUNTER| |DIVIDER| |PHASE COMPARATOE| |CHARGE PUMP|
	        +-------+   +---------+   +-------+   +----------------+   +-----------+
	               +-----------+    +---------+                            
	               |INTEGER VAL|--|N COUNTER| --     -
	               +-----------+    +---------+         Vtune				OUTPUT DIVIDER
	               +------------+       +----------------------+   +------------------+
	               |FRACTION VAL|----   |VCO CORE/2.2GHz-4.4GHz| |1/2/4/8/16/32/64| RFout A
	               +------------+         +----------------------+   +------------------+
	               +-----------+                   FEEDBACK=1        FEEDBACK=0
	               |MODULUS VAL|---------       +-----------+               +-----------+
	               +-----------+            |MULTIPLEXER|   |MULTIPLEXER| RFout B
	                                              +-----------+                 +-----------+
	        
	RFOUT = (INT + (FRAC/MOD)) x (fPFD/RF Divider)
		RFOUT is the RF frequency output. 
		INT is the integer division factor. 
		FRAC is the numerator of the fractional division (0 to MOD-1). 
		MOD is the preset fractional modulus (2 to 4095). 
		RF Divider is the output divider that divides down the VCO frequency.	

	fPFD = REFin ~ [(1 + D)/(R ~ (1 + T))]
		REFin is the reference input frequency. 
		D(DOUBLER) is the REFin doubler bit (0 or 1).
		R(R COUNTER) is the preset divide ratio of the binary 10-bit programmable reference counter (1 to 1023). 
		T(DIVIDER) is the REFin divide-by-2 bit (0 or 1).
	
	RFOUT = 100MHz,330MHz,1150MHz, 2300MHz
	VCO CORE = 2.2GHz-4.4GHz
	 	 2 = 1.1GHz-2.2GHz
	 	 4 = 550MHz-1100MHz
	 	 8 = 275MHz-550MHz
	 	 16= 137.5MHz-275MHz
	 	 32= 68.75MHz-137.5MHz
	 	 64= 34.375MHz-68.75MHz
	REFin =	10MHz
	fPFD  = 10MHz / D=0 R=0 T=0
	MOD = REFin / fRES (10MHz/500KHz=20)
	INT mode	
	 100MHz:FEEDBACK=1 RF DIVIDER=32 N=320 / FRAC=0 MODE=20 INT=320
	 330MHz:FEEDBACK=1 RF DIVIDER= 8 N=264 / FRAC=0 MODE=20 INT=264 
	1150MHz:FEEDBACK=1 RF DIVIDER= 2 N=230 / FRAC=0 MODE=20 INT=230 
	2300MHz:FEEDBACK=1 RF DIVIDER= 0 N=230 / FRAC=0 MODE=20 INT=230 

	REFin =	10MHz
	fPFD  = 1MHz / D=0 R=10 T=0
	MOD = REFin / fRES (10MHz/500KHz=20)
	INT mode	
	 100MHz:FEEDBACK=1 RF DIVIDER=32 N=3200 / FRAC=0 MODE=20 INT=3200
	 330MHz:FEEDBACK=1 RF DIVIDER= 8 N=2640 / FRAC=0 MODE=20 INT=2640 
	1150MHz:FEEDBACK=1 RF DIVIDER= 2 N=2300 / FRAC=0 MODE=20 INT=2300 
	2300MHz:FEEDBACK=1 RF DIVIDER= 0 N=2300 / FRAC=0 MODE=20 INT=2300 

	REFin =	10MHz
	fPFD  = 500KHz / D=0 R=20 T=0
	MOD = REFin / fRES (10MHz/500KHz=20)
	INT mode	
	 100MHz:FEEDBACK=0 RF DIVIDER=32 N=200 / FRAC=0 MODE=20 INT=200
	 330MHz:FEEDBACK=0 RF DIVIDER= 8 N=660 / FRAC=0 MODE=50 INT=660 
	1150MHz:FEEDBACK=0 RF DIVIDER= 2 N=2300/ FRAC=0 MODE=50 INT=2300 
*/
#define _REF		10000000		// reference frequency input.

//===================ADF4351 REGISTER BEGIN======================================
// reg0
uint16_t _INT = 3200;
uint16_t _FRAC = 0;

// reg1
uint8_t  _PHASE_ADJ = 0;				// defalut OFF
uint8_t  _PRESCALER = 1;				// defalut 4/5(Nmin=23/max f=3.6G) 1=8/9(Nmin=75 max f=4G)
uint16_t _PHASE = 1;					// 1 is recommended
uint16_t _MOD = 50;						// 2 to 4095

// reg2
uint8_t  _LOW_MODE = 0;					// Low Noise Mode 2=Low Spur Mode
uint8_t  _MUXOUT	= 6;				// OUTPUT=digital Lock Detect
uint8_t  _PREPERENCE_DOUBLER = 0;		// Disable if enable is 1
uint8_t  _RDIV2 = 0;					// Reference Divide By-2 disable if enable is 1
uint16_t _R_COUNTER = 10;				// 1 to 1023 REFin to be divided down clock
uint8_t  _DOUBLE_BUFFER = 0;			// if enable is 1
uint8_t  _CHARGE_PUMP = 7;				// 4bits 3=1.26mA 7=2.5mA
uint8_t  _LDF = 1;						// set to 0, the number of PFD cycles monitored is 40. set to 1, the number of PFD cycles monitored is 5.
uint8_t  _LDP = 1;						// set to 0, the comparison window is 10 ns. set to 1 the window is 6 ns.
uint8_t  _PD_POLARITY = 1;				// When a passive loop filter or a noninverting active loop filter is used, this bit should be set to 1. If an active filter with an inverting charac-teristic is used, this bit should be set to 0.
uint8_t  _POWER_DOWN = 0;				// Setting this bit to 0 returns the synthesizer to normal operation.
uint8_t  _CP_THREE_STATE = 0;			// This bit should be set to 0 for normal operation.
uint8_t  _COUNTER_RESET = 0;			// When this bit is set to 1, the RF synthesizer N counter and R counter are held in reset. For normal opera-tion, this bit should be set to 0.

// reg3
uint8_t  _BAND_SELECT_CLOCK_MODE = 1;	// Setting the bit to 1 selects a faster logic sequence of band selection, which is suitable for high PFD frequencies and is necessary for fast lock applications. Setting the bit to 0 is recommended for low PFD (<125 kHz) values. For the faster band select logic modes (set to 1), the value of the band select clock divider must be less than or equal to 254.
uint8_t  _ABP = 1;						// set to 0, the PFD antibacklash pulse width is 6 ns. This setting is recommended for fractional-N use.set to 1, the PFD antibacklash pulse width is 3 ns.
uint8_t  _CHARGE_CANCEL = 0;			// This has the effect of reducing PFD spurs in integer-N mode. In fractional-N mode, this bit should be set to 0.
uint8_t  _CSR = 1;						// bit to 1 enables cycle slip reduction. CSR is a method for improving lock times.
uint8_t  _CLK_DIV = 0;					// must be set to 10 to activate phase resync. These bits must be set to 01 to activate fast lock. Setting to 00 disables the clock divider.
uint16_t _CLOCK_DIVIDER = 1;			// set the 12-bit clock divider value.

// reg4
uint8_t  _FEEDBACK = 0;					// When this bit is set to 1, the signal is taken directly from the VCO. When this bit is set to 0, the signal is taken from the output of the output dividers.
uint8_t  _RF_DIVIDER = 5;				// 0:1 1:2 2:4 3:8 4:16 5:32 6:64
uint8_t  _BAND_SELECT_CLOCK_DIVIDER =1;	// 1 to 255
uint8_t  _VCO_POWER_DOWN = 0;			// Setting the bit to 0 powers the VCO up; setting this bit to 1 powers the VCO down.
uint8_t  _MTLD = 0;						// When the bit is set to 1, the supply current to the RF output stage is shut down until the part achieves lock, as measured by the digital lock detect circuitry.
uint8_t  _AUX_OUTPUT_SELECT = 0;		// If is set to 0, the auxiliary RF output is the output of the RF dividers; if is set to 1, the auxiliary RF output is the fundamental VCO frequency.
uint8_t  _AUX_OUTPUT_ENABLE = 0;		// If is set to 0, the auxiliary RF output is disabled; if is set to 1, the auxiliary RF output is enabled.
uint8_t  _AUX_OUTPUT_POWER = 0;			// Bits set the value of the auxiliary RF output power level. 0:-4dBm 1:-1dBm 2:+2dBm 3:+5dBm
uint8_t  _RF_OUTPUT_ENABLE = 1;			// The bit enables or disables the primary RF output. If is set to 0, the primary RF output is disabled; if is set to 1, the primary RF output is enabled.
uint8_t  _OUTPUT_POWER = 3;				// Bits set the value of the primary RF output power level. 0:-4dBm 1:-1dBm 2:+2dBm 3:+5dBm

// reg5
uint8_t  _LD_PIN = 1;					// Digital Lock Detect
//===================ADF4351 REGISTER END========================================

uint32_t reg0, reg1, reg2, reg3, reg4, reg5;
unsigned char reg[4];
unsigned char string[33];

enum _REG { _REG0, _REG1, _REG2, _REG3, _REG4, _REG5 };
enum freq { _100MHz, _330MHz, _1150MHz, _2300MHz };

//---------------------------------------------
// lQiϊ
// v: l 32bit
// s: i[镶 unsigned char c[33]
// len:  ʃrbg̒ɂȂ
//---------------------------------------------
void u32toBitString(unsigned int v, unsigned char* s, char len)
{
	int i, p;
	unsigned char c[33];
	
	for (i=0; i<32; i++){
		p = (v >> (31-i)) & 1;
		if (p)
			c[i] = '1';
		else
			c[i] = '0';
	}
	c[32] = 0;
	sprintf((char *)s, "%.*s", len, &c[32-len]);
}

//---------------------------------------------
// g̐ݒ
// sel: 0,1,2
//---------------------------------------------
void set_freq(int sel)
{
	switch (sel){
		case _100MHz:
				_R_COUNTER = 10;	//fPFD=1MHz
 				_MOD = 20;
 				_FEEDBACK = 1;
				_RF_DIVIDER = 5;	//32
				_INT = 3200;
				_FRAC = 0;
				#if DEBUG_SW == 1
					printf("100MHz\n");
				#endif
				break;
		case _330MHz:
				_R_COUNTER = 10;
 				_MOD = 20;
				_FEEDBACK = 1;
				_RF_DIVIDER = 3;
				_INT = 2640;
				_FRAC = 0;
				#if DEBUG_SW == 1
					printf("330MHz\n");
				#endif
				break;
		case _1150MHz:
				_R_COUNTER = 10;
 				_MOD = 20;
				_FEEDBACK = 1;
				_RF_DIVIDER = 1;
				_INT = 2300;
				_FRAC = 0;
				#if DEBUG_SW == 1
					printf("1150MHz\n");
				#endif
				break;
		case _2300MHz:
				_R_COUNTER = 10;
 				_MOD = 20;
				_FEEDBACK = 1;
				_RF_DIVIDER = 0;
				_INT = 2300;
				_FRAC = 0;
				#if DEBUG_SW == 1
					printf("2300MHz\n");
				#endif
				break;
	}
}

//---------------------------------------------
// WX^0̐ݒ
//---------------------------------------------
void set_reg0()
{
	reg0 = _INT << 15;
	reg0 |= (_FRAC << 3) & 0x7FF8;

#if DEBUG_SW == 1
	u32toBitString(reg0, string, 32);
	printf("register0\n%s\n",string);
#endif
}

//---------------------------------------------
// WX^1̐ݒ
//---------------------------------------------
void set_reg1()
{
	reg1 = 0;
	reg1 |= _PHASE_ADJ << 28;
	reg1 |= _PRESCALER << 27;
	reg1 |= (_PHASE & 0x0FFF) << 15;
	reg1 |= (_MOD & 0x0FFF) << 3;
	reg1 |= 1;

#if DEBUG_SW == 1
	u32toBitString(reg1, string, 32);
	printf("register1\n%s\n",string);
#endif
}

//---------------------------------------------
// WX^2̐ݒ
//---------------------------------------------
void set_reg2()
{
	reg2 = 0;
	reg2 |= (_LOW_MODE & 3) << 29;
	reg2 |= (_MUXOUT & 7) << 26;
	reg2 |= _PREPERENCE_DOUBLER << 25;
	reg2 |= _RDIV2 << 24;
	reg2 |= (_R_COUNTER & 0x3FF) << 14;
	reg2 |= _DOUBLE_BUFFER << 13;
	reg2 |= (_CHARGE_PUMP & 0xF) << 9;
	reg2 |= _LDF << 8;
	reg2 |= _LDP << 7;
	reg2 |= _PD_POLARITY << 6;
	reg2 |= _POWER_DOWN << 5;
	reg2 |= _CP_THREE_STATE << 4;
	reg2 |= _COUNTER_RESET << 3;
	reg2 |= 2;

#if DEBUG_SW == 1
	u32toBitString(reg2, string, 32);
	printf("register2\n%s\n",string);
#endif
}

//---------------------------------------------
// WX3O̐ݒ
//---------------------------------------------
void set_reg3()
{
	reg3 = 0;
	reg3 |= _BAND_SELECT_CLOCK_MODE << 23;
	reg3 |= _ABP << 22;
	reg3 |= _CHARGE_CANCEL << 21;
	reg3 |= _CSR << 18;
	reg3 |= (_CLK_DIV & 3) << 15;
	reg3 |= (_CLOCK_DIVIDER & 0xFFF) << 3;
	reg3 |= 3;

#if DEBUG_SW == 1
	u32toBitString(reg3, string, 32);
	printf("register3\n%s\n",string);
#endif
}

//---------------------------------------------
// WX^4̐ݒ
//---------------------------------------------
void set_reg4()
{
	reg4 = 0;
	reg4 |= _FEEDBACK << 23;
	reg4 |= (_RF_DIVIDER & 7) << 20;
	reg4 |= (_BAND_SELECT_CLOCK_DIVIDER & 0xFF) << 12;
	reg4 |= (_VCO_POWER_DOWN & 1) << 11;
	reg4 |= (_MTLD & 1) << 10;
	reg4 |= (_AUX_OUTPUT_SELECT & 1) << 9;
	reg4 |= (_AUX_OUTPUT_ENABLE & 1) << 8;
	reg4 |= (_AUX_OUTPUT_POWER & 0x3) << 6;
	reg4 |= (_RF_OUTPUT_ENABLE & 1) << 5;
	reg4 |= (_OUTPUT_POWER & 0x3) << 3;
	reg4 |= 4;

#if DEBUG_SW == 1
	u32toBitString(reg4, string, 32);
	printf("register4\n%s\n",string);
#endif
}

//---------------------------------------------
// WX^5̐ݒ
//---------------------------------------------
void set_reg5()
{
	reg5 = 0;
	reg5 |= (_LD_PIN & 3) << 22;
	// reserved[20][19]=1
	reg5 |= 3 << 19;
	reg5 |= 5;

#if DEBUG_SW == 1
	u32toBitString(reg5, string, 32);
	printf("register5\n%s\n",string);
#endif
}

//---------------------------------------------
// C[`
//---------------------------------------------
int main(int argc, char *argv[])
{
	int f = 0;
	
	if (1 < argc){
		f = atoi(argv[1]);
	}
	else {
		printf("Usage adf4351 params\n");
		printf("  param 0=100MHz,1=330MHz,2=1150MHz,3=2300MHz\n");
		printf("quit end\n");
		return 0;
	}
	
	// GPIO INIT
	iolib_init();
	BBBIO_McSPI_Init();

	// IO switching time 140nS
	iolib_setdir(ADF4351_LE, BBBIO_DIR_OUT);	
	pin_high(ADF4351_LE);

	set_freq( f );
	set_reg0();
	set_reg1();
	set_reg2();
	set_reg3();
	set_reg4();
	set_reg5();

	if(BBBIO_McSPI_Enable(BBBIO_McSPI_SPI1)) {
		BBBIO_McSPI_channel_ctrl(BBBIO_McSPI_SPI1,
				BBBIO_McSPI_CH0,
				BBBIO_McSPI_Master,
				BBBIO_McSPI_Tx_Only,		
				BBBIO_McSPI_CLDIV_64,		// 48Mhz div 64 as SPI speed
				BBBIO_McSPI_CLK_MODE0,		// CLK active high and sampling occurs on the rising edge
				BBBIO_McSPI_EN_ACT_LOW,		// CS/En pin low when active
				BBBIO_McSPI_D0O_D1I,		// data0 output , data1 input
				32);						// 32 bit TxRx per work
	}
	/*
	the ADF4351 registers should be started in the following sequence:
		1. Register 5
		2. Register 4
		3. Register 3
		4. Register 2
		5. Register 1
		6. Register 0
	*/
	pin_low(ADF4351_LE);
	BBBIO_McSPI_work(BBBIO_McSPI_SPI1, BBBIO_McSPI_CH0, reg5, 0);
	pin_high(ADF4351_LE);
	pin_low(ADF4351_LE);

	BBBIO_McSPI_work(BBBIO_McSPI_SPI1, BBBIO_McSPI_CH0, reg4, 0);
	pin_high(ADF4351_LE);
	pin_low(ADF4351_LE);

	BBBIO_McSPI_work(BBBIO_McSPI_SPI1, BBBIO_McSPI_CH0, reg3, 0);
	pin_high(ADF4351_LE);
	pin_low(ADF4351_LE);

	BBBIO_McSPI_work(BBBIO_McSPI_SPI1, BBBIO_McSPI_CH0, reg2, 0);
	pin_high(ADF4351_LE);
	pin_low(ADF4351_LE);

	BBBIO_McSPI_work(BBBIO_McSPI_SPI1, BBBIO_McSPI_CH0, reg1, 0);
	pin_high(ADF4351_LE);
	pin_low(ADF4351_LE);

	BBBIO_McSPI_work(BBBIO_McSPI_SPI1, BBBIO_McSPI_CH0, reg0, 0);
	pin_high(ADF4351_LE);

	BBBIO_McSPI_Disable(BBBIO_McSPI_SPI1);

//	while(1)
//		;

	iolib_free();
	return 0;

}
