-- ROHM DAC BU9480F interface circuit

LIBRARY ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity Mdac is
	port
		(
			Mclk		: in  std_logic;	-- Master clock 40MHz
			Reset		: in  std_logic;	-- Master Reset
			Fsamp		: in  std_logic;	-- 4times sampling clock 78.125KHz
			Rdata		: in  std_logic_vector(15 downto 0); -- DAC data/Right
			Ldata		: in  std_logic_vector(15 downto 0); -- DAC data/Left
			LRCK		: out std_logic;    -- Left/Right pulse
			BCLK		: out std_logic;    -- Base clock
			Sdata		: out std_logic;    -- Serial Out data
			Debug		: out std_logic
		);
end Mdac;

ARCHITECTURE one OF Mdac IS
	signal	shifter			: std_logic_vector(15 downto 0);
	signal	BaseT			: std_logic_vector(5 downto 0);
	signal	Cnt				: std_logic_vector(3 downto 0);
	signal	stat			: std_logic_vector(1 downto 0);
	signal	Left,Td,Mdlrc	: std_logic;

BEGIN
-------------------------------------------------------------------------
--		Ta : Alter 16Khz
--		Td : 1/10 masker clock
--		Te : 1/5 Masterclock
--		f16 : 1/2 Te
--		f3200 : 3200Hz signal
-------------------------------------------------------------------------
--		1/32 counter
-------------------------------------------------------------------------
	process(Mclk,Reset)
	begin
		if Reset = '0' then Cnt <= "0000"; Td <= '0';
		elsif Rising_edge(Mclk) then
			if Cnt = "1110"		then Td <= '1';
								else Td <= '0';
			end if; 
			if Fsamp = '1'		then Cnt <= "0000";
								else Cnt <= Cnt + 1;
			end if;
		end if;
	end process;

-- Start Timing ---------------------------------------------------------
-- stat = 00   waitint next shift
-- stat = 01   counter start
-- stat = 10   data shift aria
-- stat = 11   shift stop eria
	process(Mclk,Reset)
	begin
		if Reset = '0' then stat <= "00";
		elsif Rising_edge(Mclk) then
			if Fsamp = '1'		then stat <= "11";
			else
				if Td = '1' then
					case stat is
						when "11" => stat <= "01";
						when "01" => stat <= "10";
						when "10" => if BaseT(4 downto 1) = "1111" then stat <= "00";
									 else stat <= stat;
									 end if;
						when others => stat <= stat;
					end case;
				else stat <= stat;
				end if;
			end if;
		end if; 
	end process;				

-- Base 32 counter ----
	process(Mclk,Reset)
	begin
		if Reset = '0' then BaseT <= "000000"; Mdlrc <= '0';
		elsif (Rising_edge(Mclk)) then
			if (BaseT = "011111") and (Td = '1')	then
				 Mdlrc <= not Mdlrc;
			else Mdlrc <= Mdlrc;
			end if;
			if Td = '1'			then BaseT <= BaseT + 1;
			else
				if stat = "01"	then BaseT <= "111111";
								else BaseT <= BaseT;
				end if;
			end if;
		end if;
	end process;

-- Channel Pulse -------
--	process(Mclk,Reset)
--	begin
--		if Reset = '0' then Left <= '0';Ta <= '0';
--		elsif (Rising_edge(Mclk)) then
--			if Td = '1' then
--				if stat = "00" 	then Ta <= Ta; Left <= Ta;
--							   	else Ta <= not Left; Left <= Left;
--				end if;
--			else Ta <= Ta; Left <= Left;
--			end if;
--		end if;
--	end process;
	Left <= Mdlrc;

-- Data Shiffter -------
	process(Mclk,Reset)
		variable tempa : std_logic_vector(15 downto 0);

	begin
		if Reset = '0' then	shifter <= "0000000000000000";
		elsif (Rising_edge(Mclk)) then
			if stat  = "01"	then
				if Left = '1' 	then tempa := Ldata;
								else tempa := Rdata;
				end if;
			else
				tempa(15 downto 1) := shifter(14 downto 0);
				tempa(0) := '0';
			end if;
			if (Td = '1') and (BaseT(0) = '1')	then Shifter <= tempa;
												else Shifter <= Shifter;
			end if;
		end if;
	end process;

	LRCK <= Left;
	BCLK <= BaseT(0);
	Sdata <= Shifter(15);
	
	Debug <= BaseT(0);
--	Debug <= Td;
--	Debug <= Left;
	
END one;

