---------------------------------------------------------------------
-- 		AD73311 interface
--					(C)Copyright 2013,12,28 Y nishimura
---------------------------------------------------------------------
LIBRARY ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
LIBRARY lpm;
use lpm.lpm_components.all;

entity codec is
	port
		(
			Mclk		: in	std_logic;	-- Master clock  40MHz
			Clk65Mhz	: in    std_logic;	-- 65MHz clock
			Reset		: in	std_logic;	-- Master Reset
			Gate63k		: in    std_logic;	-- 63k gate signal
			CWmode		: in	std_logic;	-- CW transmit mode
			CWkey		: in    std_logic;	-- CW key in
			CWpitch		: in	std_logic_vector(15 downto 0); -- CW pitch frequency
			Mute		: in    std_logic;	-- Mute control
			Coclk		: in	std_logic;	-- Codec Clock input
			Costb		: in	std_logic;	-- Codec Strobe
			Corx		: in	std_logic;	-- Codec RX data
			Dvol		: in    std_logic;  -- Volume control enable
			Dwen		: in	std_logic;	-- DAC data Write enable
			Beep		: in    std_logic_vector(7 downto 0);
			Idata		: in	std_logic_vector(15 downto 0);  -- DAC input
			DacLoad		: in	std_logic;	-- DAC load timing
			DAdata		: in    std_logic_vector(15 downto 0);
			Adload		: out	std_logic;	-- Adc load timing
			Adcout		: out	std_logic_vector(15 downto 0);
			Dout		: out	std_logic;	-- Codec data out
			LRCK		: out 	std_logic;  -- Left/Right pulse
			BCLK		: out 	std_logic;  -- Base clock
			Sdata		: out 	std_logic;  -- Serial Out data
			AdcSamp		: out 	std_logic;	-- ADC sampling pulse
			Debug		: out 	std_logic
		);
end codec;

ARCHITECTURE one OF codec IS
	signal	Vodata,CWlevel	: std_logic_vector(35 downto 0);
	signal	Dmain,Vol,CWvol	: std_logic_vector(17 downto 0);
	signal	Vole			: std_logic_vector(17 downto 0);
	signal	Adcd,Oda,Dregs	: std_logic_vector(15 downto 0);
	signal	Rdat,Volda,Vold : std_logic_vector(15 downto 0);
	signal	Otest,Odata		: std_logic_vector(15 downto 0);
	signal	CWphase,CWtone	: std_logic_vector(15 downto 0);
	signal	CWfreq			: std_logic_vector(15 downto 0);
	signal	Runder			: std_logic_vector(5 downto 0);
	signal	Lcnt,CWcnt		: std_logic_vector(4 downto 0);
	signal	Wadd,Radd		: std_logic_vector(3 downto 0);
	signal	Edtt,Wsta,Vsta	: std_logic_vector(1 downto 0);
	signal	Edttf			: std_logic_vector(1 downto 0);
	signal	Ta,Tb,Delay,Wg	: std_logic;
	signal	Full,Tet,Tgg	: std_logic;
	signal	DebugMdac		: std_logic;

	component Mdac is
		port
			(
				Mclk		: in  std_logic;	-- Master clock 65MHz
				Reset		: in  std_logic;	-- Master Reset
				Fsamp		: in  std_logic;	-- 4times sampling clock 80KHz
				Rdata		: in  std_logic_vector(15 downto 0); -- DAC data/Right
				Ldata		: in  std_logic_vector(15 downto 0); -- DAC data/Left
				LRCK		: out std_logic;    -- Left/Right pulse
				BCLK		: out std_logic;    -- Base clock
				Sdata		: out std_logic;    -- Serial Out data
				Debug		: out std_logic
			);
	end component;

	component SinCosR is
		port
			(
				Hclk		: in  std_logic;	-- Master 4fsc clock
				Reset		: in  std_logic;	-- Master Reset
				Phase		: in  std_logic_vector(15 downto 0);
				Xaxis		: out std_logic_vector(15 downto 0)
			);
	end component;

BEGIN
	AdcSamp <= Tgg;
-- CW side tone gen. --------------------------------------------
	process(Clk65Mhz,Reset)
		variable Tempa,Tempb : std_logic_vector(15 downto 0);

	begin
		if Reset = '0'	then
			CWphase <= "0000000000000000"; CWfreq <= "0000000000000000";
		elsif Rising_edge(Clk65Mhz) then
			if CWpitch(15) = '0'	then Tempa(15 downto 14) := "00";
									else Tempa(15 downto 14) := "11";
			end if;
			Tempa(13 downto 0) := CWpitch(14 downto 1); -- 1/4
			if CWpitch(15) = '0'	then Tempb(15 downto 12) := "0000";
									else Tempb(15 downto 12) := "1111";
			end if;
			Tempb(11 downto 0) := CWpitch(13 downto 2); -- 1/16
			CWfreq <= "0000001001101011" + Tempa - Tempb;
			if Gate63k = '1'	then
				 CWphase <= CWphase + CWfreq;
			else CWphase <= CWphase;
			end if;
		end if;
	end process;
	
	U7: SinCosR port map
			(
				Hclk		=> Clk65Mhz,	-- Master 4fsc clock
				Reset		=> Reset,		-- Master Reset
				Phase		=> CWphase,	
				Xaxis		=> CWtone
			);

-- Volume control -----------------------------------------------
	process(Clk65Mhz,Reset)
	begin
		if Reset = '0'	then Dmain <= "000000000000000000";
		elsif Rising_edge(Clk65Mhz) then
			if CWmode = '0'	then
				Dmain(17 downto 2) <= DAdata;
				Dmain(1 downto 0) <= "00";
			else
				Dmain(17) <= CWtone(15);
				Dmain(16 downto 1) <= CWtone; Dmain(0) <= '0';
			end if;
		end if;
	end process;

	process(Clk65Mhz,Reset)
	begin
		if Reset = '0'	then
			Vsta <= "00"; Vold <= "0000000000000000";
		elsif Rising_edge(Clk65Mhz) then
			case Vsta is
				when "00" => if Dvol = '1'	then Vsta <= "01";
											else Vsta <= "00";
							 end if;
				when "01" => Vsta <= "11";
				when "10" => Vsta <= "00";
				when "11" => if Dvol = '0'	then Vsta <= "10";
											else Vsta <= "11";
							 end if;
				when others => Vsta <= "00";
			end case;
			if Vsta = "01"		then Vold <= Idata;
								else Vold <= Vold;
			end if;
		end if;
	end process;
	
	process(Clk65Mhz,Reset)
	begin
		if Reset = '0'	then
			Vol <= "000000000000000000"; CWcnt <= "00000";
		elsif Rising_edge(Clk65Mhz) then
			if Gate63k = '1'	then
				if CWkey = '1'	then
					if CWcnt = "11111"	then CWcnt <= CWcnt;
										else CWcnt <= CWcnt + 1;
					end if;
				else
					if CWcnt = "00000"	then CWcnt <= CWcnt;
										else CWcnt <= CWcnt - 1;
					end if;
				end if;
			else CWcnt <= CWcnt;
			end if;
			Vol(17) <= '0';
			if CWmode = '1'	then
				Vol(16 downto 0) <= CWlevel(34 downto 18);
			else
				Vol(16 downto 1) <= Vold; Vol(0) <= '0';
			end if;
		end if;
	end process;

	CWvol(17) <= '0'; CWvol(16 downto 12) <= CWcnt;
	CWvol(11 downto 0) <= "000000000000";
	Vole(17) <= '0'; Vole(16 downto 1) <= Vold; Vole(0) <= '0';
	U8: lpm_mult GENERIC map (
			LPM_WIDTHA => 18,LPM_WIDTHB => 18,LPM_WIDTHP => 36,
			LPM_REPRESENTATION => "SIGNED",LPM_PIPELINE => 2) 
  	   PORT map (
					dataa => CWvol,
					datab => Vole,
					aclr  => '0',
					clock => Clk65Mhz,
					clken => '1',
        			result => CWlevel
				); 
	
	U1: lpm_mult GENERIC map (
			LPM_WIDTHA => 18,LPM_WIDTHB => 18,LPM_WIDTHP => 36,
			LPM_REPRESENTATION => "SIGNED",LPM_PIPELINE => 2) 
  	   PORT map (
					dataa => Dmain,
					datab => Vol,
					aclr  => '0',
					clock => Clk65Mhz,
					clken => '1',
        			result => Vodata
				); 
 
-- Serial Clock Edge Detect ------------------------------------
	process(Mclk,Reset)
	begin
		if Reset = '0'	then Edtt <= "00";
		elsif Rising_edge(Mclk) then
			case Edtt is
				when "00" => if Coclk = '1'	then Edtt <= "01";
											else Edtt <= "00";
							 end if;
				when "01" => if Coclk = '0'	then Edtt <= "11";
											else Edtt <= "01";
							 end if;
				when "10" => if Coclk = '1'	then Edtt <= "00";
											else Edtt <= "10";
							 end if;
				when "11" => Edtt <= "10";
				when others => Edtt <= "00";
			end case;
			if Edtt = "11"	then Tgg <= Costb;
							else Tgg <= '0';
			end if;
		end if;
	end process;

--	process(Clk65Mhz,Reset)
--	begin
--		if Reset = '0'	then Edttf <= "00"; Tgg <= '0';
--		elsif Rising_edge(Clk65Mhz) then
--			case Edttf is
--				when "00" => if Coclk = '1'	then Edttf <= "01";
--											else Edttf <= "00";
--							 end if;
--				when "01" => if Coclk = '0'	then Edttf <= "11";
--											else Edttf <= "01";
--							 end if;
--				when "10" => if Coclk = '1'	then Edttf <= "00";
--											else Edttf <= "10";
--							 end if;
--				when "11" => Edttf <= "10";
--				when others => Edttf <= "00";
--			end case;
--			if Edttf = "11"	then Tgg <= Costb;
--							else Tgg <= '0';
--			end if;
--		end if;
--	end process;

-- Data Load counter --------------------------------------------
	process(Mclk,Reset)
	begin
		if Reset = '0'	then
			Lcnt <= "00000"; Ta <= '0'; Tb <= '0';
			Adload <= '0';
		elsif Rising_edge(Mclk) then
			Adload <= Tb;
			Ta <= Lcnt(4);
			Tb <= Lcnt(4) and (not Ta);
			if Edtt = "11"	then
				if Costb = '1'	then Lcnt <= "00000";
				else
					if Lcnt(4) = '0' then Lcnt <= Lcnt + 1;
									 else Lcnt <= Lcnt;
					end if;
				end if;
			else Lcnt <= Lcnt;
			end if;
		end if;
	end process;

-- Rx data receiver ---------------------------------------------
	process(Mclk,Reset)
		variable Tempa : std_logic_vector(15 downto 0);

	begin
		if Reset = '0'	then
			Adcd <= "0000000000000000"; Oda <= "0000000000000000";
		elsif Rising_edge(Mclk) then
			Tempa(15 downto 1) := Adcd(14 downto 0);
			Tempa(0) := Corx;
			if Edtt = "11"	then
				if Lcnt(4) = '0'		then Adcd <= Tempa;
										else Adcd <= Adcd;
				end if;
				if Lcnt = "01111"		then
					 Oda(15 downto 1) <= Tempa(14 downto 0); Oda(0) <= '0';
				else Oda <= Oda;
				end if;
			else
				Adcd <= Adcd; Oda <= Oda;
			end if;
		end if;
	end process;
	Adcout <= Oda;

-- Tx data FIFO budder ------------------------------------------
	process(Mclk,Reset)
	begin
		if Reset = '0'	then Wsta <= "00";
		elsif Rising_edge(Mclk) then
			case Wsta is
				when "00" => if Dwen = '1'	then Wsta <= "01";
											else Wsta <= "00";
							 end if;
				when "01" => Wsta <= "11";
				when "10" => Wsta <= "00";
				when "11" => if Dwen = '0'	then Wsta <= "10";
											else Wsta <= "11";
							 end if;
				when others => Wsta <= "00";
			end case;
		end if;
	end process;
	
	process(Mclk,Reset)
	begin
		if Reset = '0'	then
			Wadd <= "0000"; Radd <= "0000"; Full <= '0';
		elsif Rising_edge(Mclk) then
			if Wadd = Radd		then Full <= '1';
								else Full <= '0';
			end if;
			if Wsta = "10"		then Wadd <= Wadd + 1;
								else Wadd <= Wadd;
			end if;
			if Tb = '1'			then
				if Full = '1'	then Radd <= Radd;
								else Radd <= Radd + 1;
				end if;
			else Radd <= Radd;
			end if;
		end if;
	end process;

	Wg <= (not Wsta(1)) and Wsta(0);  -- Write gate
	U2: lpm_ram_dp
   		GENERIC map (
						LPM_WIDTH =>16, LPM_WIDTHAD => 4,
      					LPM_OUTDATA => "REGISTERED")
		port map (
					data => Idata,
					wraddress => Wadd,
					wrclken => '1',
					wren => Wg,
					wrclock => Mclk,
					rdaddress => Radd,
					rden => '1',
					rdclken => '1',
					rdclock => Mclk,
					q => Rdat
				  );

-- Data shifter -------------------------------------------------
-- 	process(Mclk,Reset)
--	begin
--		if Reset = '0'	then Otest <= "0000000000000000";
--		elsif Rising_edge(Mclk) then
--			if Edtt = "11"	then
--				if Costb = '1'	then Otest <= Otest + 1;
--								else Otest <= Otest;
--				end if;
--			else Otest <= Otest;
--			end if;
--		end if;
--	end process;

 	process(Mclk,Reset)
		variable Tempa		 : std_logic_vector(15 downto 0);

	begin
		if Reset = '0'	then 
			Dregs <= "0000000000000000"; Delay <= '0'; 
		elsif Rising_edge(Mclk) then
			Tempa(15 downto 1) := Dregs(14 downto 0); Tempa(0) := '0';
			if Edtt = "11"	then
				if Costb = '1'	then
					if Full = '0'		then
						Dregs <= Rdat;
					else
						Dregs(15) <= '0'; Dregs(14 downto 0) <= Oda(14 downto 0);
					end if;
				else Dregs <= Tempa;
				end if;
			else Dregs <= Dregs;
			end if;
			if Edtt = "00"	then Delay <= Dregs(15);
							else Delay <= Delay;
			end if;
		end if;
	end process;
	Dout <= Delay;
	
 	process(Clk65Mhz,Reset)
		variable Tempb,tempf : std_logic_vector(14 downto 0);
		variable tempc,tempd : std_logic_vector(6 downto 0);
		variable tempe		 : std_logic_vector(6 downto 0);

	begin
		if Reset = '0'	then 
			Runder <= "000000";
			Odata <= "0000000000000000";
		elsif Rising_edge(Clk65Mhz) then
			tempc(6) := '0'; tempc(5 downto 0) := Vodata(18 downto 13);
			tempd(6) := '0'; tempd(5 downto 0) := Runder;
			tempe := tempc + tempd;
			if Beep(7) = '1'	then tempf(14 downto 13) := "11";
								else tempf(14 downto 13) := "00";
			end if;
			tempf(12 downto 5) := Beep; tempf(4 downto 0) := "00000";
			if tempe(6) = '1'	then Tempb := Vodata(33 downto 19) + tempf + 1;
								else Tempb := Vodata(33 downto 19) + tempf;
			end if;
			Runder <= tempe(5 downto 0);
			if Mute = '1'		then 
				Odata(15 downto 1) <= tempf; Odata(0) <= '0';
			else
				Odata(15 downto 1) <= Tempb; Odata(0) <= '0';
			end if;
		end if;
	end process;
	
	U3: Mdac port map
			(
				Mclk	=> Clk65Mhz,		-- Master clock 65MHz
				Reset	=> Reset,			-- Master Reset
				Fsamp	=> Gate63k,			-- 4times sampling clock 80KHz
				Rdata	=> Odata,			-- DAC data/Right
				Ldata	=> Odata,			-- DAC data/Left
				LRCK	=> LRCK,		    -- Left/Right pulse
				BCLK	=> BCLK,			-- Base clock
				Sdata	=> Sdata,			-- Serial Out data
				Debug	=> DebugMdac 
			);

--	Debug <= DebugMdac;
--	Debug <= Edtt(1) and Edtt(0);
	Debug <= Coclk;
--	Debug <= Costb;

END one;

