-- BlackFin serial interface ---------------------------------------------------
--		(C)Copyright 2014,03,15 by nishimura yoshikazu
--		  (TX FPGA -> DSP) 30bits length x2chan
--			if wide = 0 then
--				prim line0-1
--					** Frequecny(16bits)*Exp*ComAdd(4bits)*Comdata(MSB4bits)*w0
--				Second line0-1
--					** 000000000000*Comdata(LSB16bits)*01 
--				prim line0-2
--					** Idata(28bits)*w0
--				Second line0-2
--					** Qdata(28bits)*11 
--				w:wide flag  1:wide  0:narrow
--			else
--				prim line0-1
--					** Idata(16bits)*Exp(4bits)*ComAdd(4bits)*Comdata(MSB4bits)*w0
--				Second line0-1
--					** Qdata(16bits)*Comdata(LSB12bits)*w1
--			end if; 
--			if wide = '0' then
--				prim line1-1
--					** IdataSub(28bits)*"00"
--				Second line1-1
--					** QdataSub(28bits)*"01" 
--				prim line1-2
--					** HF-Idata(16bits)*ExpHF(4bits)*Mute(2bits)*HFmode(4bits)*"10"
--				Second line1-2
--					** HF-Qdata(16bits)*"000000000000"*11
--			else
--				prim line1
--					** HF-Idata(16bits)*ExpHF(4bits)*Mute(2bits)*HFmode(4bits)*"1100"
--				Second line1-1
--					** HF-Qdata(16bits)*FrequencyOffset[15..8]*"000011"
--				Second line1-2
--					** HF-Qdata(16bits)*FrequencyOffset[7..0]*"111111"
--			end if;
--		  (RX DSP -> FPGA) 28bits length x2chan
--			prim line
--				** R-Main(15bits)*0*L-Main(15bits)
--				** R-Main(15bits)*1*L-Main(15bits)
--			Second line
--				** R-Sub (15bits)*1*L-Sub (15bits)
--				** Smeter(16bits)*Flags
--------------------------------------------------------------------------------
LIBRARY ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
LIBRARY lpm;
use lpm.lpm_components.all;

entity DSPserialIFTwo is
	port
		(
			Hclk		: in  std_logic;	-- Master clock
			HHclk		: in  std_logic;	-- 65MHz clock
			Reset		: in  std_logic;	-- Master Reset
			Fgate		: in  std_logic;	-- Data Start trigger
			Wen			: in  std_logic;	-- Sh write enable
			Rfs			: in  std_logic;	-- Serial rec frame start
			Rdp			: in  std_logic;	-- Serial rec prim
			Rds			: in  std_logic;	-- Serial rec second
			Rdps		: in  std_logic;	-- 2nd serial prim line ***
			Wide		: in  std_logic;	-- 1:wide mode 0:narrow mode
			HFmode		: in  std_logic_vector(5 downto 0);  -- HFmode flag
			HFdataI		: in  std_logic_vector(15 downto 0); -- HF I data
			HFdataQ		: in  std_logic_vector(15 downto 0); -- HF Q data
			HFexp		: in  std_logic_vector(3 downto 0);  -- HF exp data
			Shadd		: in  std_logic_vector(3 downto 0);  -- Sh address
			Shdata		: in  std_logic_vector(15 downto 0); -- Sh bus
			InEx		: in  std_logic_vector(3 downto 0);  -- Wide I/Q exp
			InIf		: in  std_logic_vector(15 downto 0); -- Wide I data
			InQf		: in  std_logic_vector(15 downto 0); -- Wide Q data
			IdataSub	: in  std_logic_vector(27 downto 0); -- I data input
			QdataSub	: in  std_logic_vector(27 downto 0); -- Q data input
			Foffset		: in  std_logic_vector(19 downto 0); -- Frequency Offset
			Cgate		: out std_logic;	-- Clock gate for PLL
			Tclk		: out std_logic;	-- Serial Transmit clock
			Tfs			: out std_logic;	-- Serial Transmit Frame start
			Tdp			: out std_logic;	-- Primary data out channel 0
			Tds			: out std_logic;	-- secondry data out channel 0
			TdpSub		: out std_logic;	-- Primary data out channel 1
			TdsSub		: out std_logic;	-- secondry data out channel 1
			DacLoad		: out std_logic;
			DacR		: out std_logic_vector(15 downto 0);
			DacL		: out std_logic_vector(15 downto 0);
			MacR		: out std_logic_vector(15 downto 0);
			MacL		: out std_logic_vector(15 downto 0);
			NacR		: out std_logic_vector(15 downto 0);
			NacL		: out std_logic_vector(15 downto 0);
			Smeter		: out std_logic_vector(15 downto 0);
			Flags		: out std_logic_vector(15 downto 0);
			Tepa		: out std_logic;
			FixI		: in  std_logic_vector(27 downto 0);
			FixQ		: in  std_logic_vector(27 downto 0);
			Debug		: out std_logic
		);
end DSPserialIFTwo;

ARCHITECTURE one OF DSPserialIFTwo IS
	signal	SendP,SendS			: std_logic_vector(28 downto 0);
	signal	SendPSub,SendSSub	: std_logic_vector(28 downto 0);
	signal	RecP,RecS,RecT,Smet	: std_logic_vector(15 downto 0);
	signal	Rram,LdacR,SdacR	: std_logic_vector(15 downto 0);
	signal	LifR				: std_logic_vector(15 downto 0);
	signal	LdacL,SdacL,Aflg	: std_logic_vector(14 downto 0);
	signal	LifL				: std_logic_vector(14 downto 0);
	signal	Rcnt				: std_logic_vector(5 downto 0);
	signal	Madd				: std_logic_vector(3 downto 0);
	signal	Lcnt				: std_logic_vector(2 downto 0);
	signal	Mwsta,Sta,Lmcnt		: std_logic_vector(1 downto 0);
	signal	Ta,Tb,Tc,Td,Te,Tf	: std_logic;
	signal	Tg,Talt,Tcc,Wcnt	: std_logic;
	signal	Smode,Tepb			: std_logic;

BEGIN
-------------------------------------------------------------------------
--		SH->DSP data buffeing
--
-------------------------------------------------------------------------
----- SH access timing generator -----
	process(Hclk,Reset)
	begin
		if Reset = '0' then Mwsta <= "00";
		elsif Rising_edge(Hclk) then
			case Mwsta is
				when "00" => if Wen = '1'	then Mwsta <= "01";
											else Mwsta <= "00";
							 end if;
				when "01" => Mwsta <= "11";
				when "10" => Mwsta <= "00";
				when "11" => if Wen = '1'	then Mwsta <= "11";
											else Mwsta <= "10";
							 end if;
				when others => Mwsta <= "00";
			end case;
		end if;
	end process;

	Ta <= '1';
	Tb <= (not Mwsta(1)) and Mwsta(0);  -- Memory write enable
	U1: lpm_ram_dp
   		GENERIC map (
						LPM_WIDTH =>16, LPM_WIDTHAD => 4,
      					LPM_OUTDATA => "REGISTERED")
		port map (
					data => Shdata,
					wraddress => Shadd,
					wrclken => Ta,
					wren => Tb,
					wrclock => Hclk,
					rdaddress => Madd,
					rden => Ta,
					rdclken => Ta,
					rdclock => HHclk,
					q => Rram
				  );

-------------------------------------------------------------------------
--		ISB and CW and WFM
-------------------------------------------------------------------------
	process(Hclk,Reset)
	begin
		if Reset = '0' then
			Smode <= '0'; Lmcnt <= "00"; Cgate <= '0';
		elsif Rising_edge(Hclk) then
			Lmcnt <= Lmcnt + 1;
			if Lmcnt = "01"		then Cgate <= '1';
								else Cgate <= '0';
			end if;
			if (Tb = '1') and (Shadd = "0001") then
				case Shdata(3 downto 0) is
					when "0010" => Smode <= '1';
					when "1000" => Smode <= '1';
					when "1001" => Smode <= '1';
					when others => Smode <= '0';
				end case;
			else
				Smode <= Smode;
			end if;
		end if;
	end process;

-------------------------------------------------------------------------
--		1/2 count
-------------------------------------------------------------------------
	process(HHclk,Reset)
	begin
		if Reset = '0' then
			Talt <= '0'; Lcnt <= "000"; Td <= '0';
		elsif Rising_edge(HHclk) then
			Lcnt <= Lcnt + 1;
			if Tc = '1'			then Talt <= not Talt;
								else Talt <= Talt;
			end if;
			if Lcnt = "010"		then Td <= '1';
								else Td <= '0';
			end if;
		end if;
	end process;
	Tclk <= Lcnt(2);	-- Serial transmit clock
	Tepa <= Tepb;

----- Read address generator -----
	process(HHclk,Reset)
	begin
		if Reset = '0' then 
			Madd <= "0000";
		elsif Rising_edge(HHclk) then
			if Tcc = '1'	then Madd <= Madd + 1;
							else Madd <= Madd;
			end if;
		end if;
	end process;

-------------------------------------------------------------------------
--		Transmitting timing
-------------------------------------------------------------------------
----- Serial send start timming -----
	process(HHclk,Reset)
	begin
		if Reset = '0' then Sta <= "00"; Tfs <= '0'; Tc <= '0';
		elsif Rising_edge(HHclk) then
			case Sta is
				when "00" => if Fgate = '1'		then Sta <= "01";
												else Sta <= "00";
							 end if;
				when "01" => if Lcnt = "010"	then Sta <= "11"; Tc <= '1'; Tfs <= '1';
												else Sta <= "01";
							 end if;
				when "10" => if Lcnt = "011" 	then Sta <= "00"; Tfs <= '0';
												else Sta <= "10";
							 end if; 
				when "11" => Sta <= "10"; Tc <= '0'; 
				when others => Sta <= "00"; Tfs <= '0';
			end case;
		end if;
	end process;
--	Tfs <= Sta(1) and (not Sta(0));
--	Tc <= Sta(1) and Sta(0);
	
	process(Talt,Tc,Wide)
	begin
		if Wide = '1'		then Tcc <= Tc;
		else
			if Talt = '0'	then Tcc <= '0';
							else Tcc <= Tc;
			end if;
		end if;
	end process;

--------------------------------------------------------------------------
--	Data Shifter for the channel 0
--------------------------------------------------------------------------
	process(HHclk,Reset)
		variable Tempa,Tempb,Tempc,Tempd : std_logic_vector(28 downto 0);
		
	begin
		if Reset = '0' then
			SendP <= "00000000000000000000000000000";
			SendS <= "00000000000000000000000000000"; Tg <= '0';
		elsif Rising_edge(HHclk) then
			Tempa(28 downto 1)  := SendP(27 downto 0);
			Tempa(0) := '0';
			Tempb(28 downto 1)  := SendS(27 downto 0);
			Tempb(0) := '1';
			Tempc(0) := Wide;
			Tempd(0) := Talt;
			if wide = '0'	then
				if Talt = '0'	then
					Tempc(28 downto 9) := Foffset;
					Tempc(8 downto 5)   := Madd;
					Tempc(4 downto 1)   := Rram(15 downto 12);
					Tempd(28 downto 17) := "000000000000";
					Tempd(16 downto 1)  := Rram;
				else
					Tempc(28 downto 1)  := FixI;
					Tempd(28 downto 1)  := FixQ;
				end if;
			else
				Tempc(8 downto 5)   := Madd;
				Tempc(4 downto 1)   := Rram(15 downto 12);
				Tempc(28 downto 13) := InIf;
				Tempc(12 downto 9)  := InEx;
				Tempd(28 downto 13) := InQf;
				Tempd(12 downto 1)  := Rram(11 downto 0);
			end if;
			if Tc = '1'			then Tg <= '1';
			else
				if Lcnt = "011"	then Tg <= '0';
								else Tg <= Tg;
				end if;
			end if;
			if Lcnt = "011"		then
				if Tg = '1'		then SendP <= Tempc; SendS <= Tempd;
								else SendP <= Tempa; SendS <= Tempb;
				end if;
			else SendP <= SendP; SendS <= SendS;
			end if;
		end if;
	end process;
	Tdp <= SendP(28); Tds <= SendS(28);

--------------------------------------------------------------------------
--	Data Shifter for the channel 1
--------------------------------------------------------------------------
	process(HHclk,Reset)
		variable Tempa,Tempb,Tempc,Tempd : std_logic_vector(28 downto 0);
		
	begin
		if Reset = '0' then
			SendPSub <= "00000000000000000000000000000";
			SendSSub <= "00000000000000000000000000000";
			Wcnt <= '0';
		elsif Rising_edge(HHclk) then
			Tempa(28 downto 1)  := SendPSub(27 downto 0);
			Tempa(0) := '0';
			Tempb(28 downto 1)  := SendSSub(27 downto 0);
			Tempb(0) := '1';
			Tempd(0) := '1';
			Tempc(0) := Talt;
			if Wide = '0'	then
				if Talt = '0'	then
					Tempc(28 downto 1) := IdataSub;
					Tempd(28 downto 1) := QdataSub;
				else
					Tempc(28 downto 13) := HFdataI;
					Tempc(12 downto 9)  := HFexp;
					Tempc(8 downto 7)   := HFmode(5 downto 4); 
					Tempc(6 downto 3)   := HFmode(3 downto 0);
					Tempc(2 downto 1)   := "11";
					Tempd(28 downto 13) := HFdataQ;
					Tempd(12 downto 1)  := "000000000000";
				end if;
			else
				Tempc(28 downto 13) := "0000000000000000";
				Tempc(12 downto 9)  := "0000";
				Tempc(8 downto 7)   := HFmode(5 downto 4);
				Tempc(6 downto 3)   := HFmode(3 downto 0);
				Tempc(2 downto 1)   := "00";
				Tempd(28 downto 1) := "0000000000000000000000000000";
			end if;
			if Lcnt = "011"		then
				if Tg = '1'		then
					 SendPSub <= Tempc; SendSSub <= Tempd; Wcnt <= not Wcnt;
				else SendPSub <= Tempa; SendSSub <= Tempb; Wcnt <= Wcnt;
				end if;
			else SendPSub <= SendPSub; SendSSub <= SendSSub; Wcnt <= Wcnt;
			end if;
		end if;
	end process;
	TdpSub <= SendPSub(28); TdsSub <= SendSSub(28);

-------------------------------------------------------------------------
--		DSP -> SH data buffeing
--
-------------------------------------------------------------------------
----- Rec data counter -----
	process(HHclk,Reset)
	begin
		if Reset = '0' then Rcnt <= "000000";
		elsif Rising_edge(HHclk) then
			if Td = '1'					then
				if Rfs = '1'			then Rcnt <= "000011";
				else
					if (Rcnt(5) = '1') and (Rcnt(3) = '1')	then
						Rcnt <= Rcnt;
					else
						Rcnt <= Rcnt + 1;
					end if; 
				end if;
			else
				Rcnt <= Rcnt;
			end if;
		end if;
	end process;

----- Data Shifter -----
	process(HHclk,Reset)
		variable Tempa,Tempb,Tempc : std_logic_vector(15 downto 0);
		
	begin
		if Reset = '0' then
			RecP <= "0000000000000000";
			RecS <= "0000000000000000";
			RecT <= "0000000000000000";
		elsif Rising_edge(HHclk) then
			Tempa(15 downto 1) := RecP(14 downto 0);
			Tempa(0) := Rdp;
			Tempb(15 downto 1) := RecS(14 downto 0);
			Tempb(0) := Rds;
			Tempc(15 downto 1) := RecT(14 downto 0);
			Tempc(0) := Rdps;
			if Td = '1'		then
				Recp <= Tempa; RecS <= Tempb; RecT <= Tempc;
			else
				RecP <= RecP;  RecS <= RecS;  RecT <= RecT;
			end if;
		end if;
	end process;

----- Data load timing -----
	process(HHclk,Reset)
	begin
		if Reset = '0' then
			Te <= '0'; Tf <= '0'; DacLoad <= '0';
		elsif Rising_edge(HHclk) then
			if Rcnt = "010011"				then Tf <= '1';		--17bits receive
											else Tf <= '0';
			end if; 
			if Rcnt = "100010"				then Te <= '1';		--15bits receive
											else Te <= '0';
			end if;
			if Te = '1'						then DacLoad <= Td;
											else DacLoad <= '0';
			end if;
		end if;
	end process;

----- Dac data load -----
	process(HHclk,Reset)
		variable Tempa : std_logic_vector(1 downto 0);
		
	begin
		if Reset = '0' then
			LdacR <= "0000000000000000"; SdacR <= "0000000000000000";
			Smet  <= "0000000000000000"; LifR  <= "0000000000000000"; Tepb <= '0';
		elsif Rising_edge(HHclk) then
			if Td = '1'		then
				if Tf = '1'	then
					Tepb <= not Tepb;
					LdacR <= RecP; LifR <= RecT;
					if RecP(0) = '1'	then
						SdacR <= SdacR; Smet <= RecS;
					else
						SdacR <= RecS;  Smet <= Smet;
					end if;
				else
					Tepb <= Tepb;
					LdacR <= LdacR; SdacR <= SdacR;
					Smet <= Smet; LifR <= LifR;
				end if;
			else
				Tepb <= Tepb;
				LdacR <= LdacR; SdacR <= SdacR;
				Smet <= Smet; LifR <= LifR;
			end if;
		end if;
	end process;
	
	process(HHclk,Reset)
	begin
		if Reset = '0' then
			LdacL <= "000000000000000"; SdacL <= "000000000000000";
			Aflg  <= "000000000000000"; LifL  <= "000000000000000"; 
		elsif Rising_edge(HHclk) then
			if Td = '1'		then
				if Te = '1'	then
					LdacL <= RecP(14 downto 0); LifL <= RecT(14 downto 0);
					if LdacR(0) = '0'	then
						SdacL <= RecS(14 downto 0);
						Aflg  <= Aflg;
					else
						SdacL <= SdacL;
						Aflg  <= RecS(14 downto 0);
					end if;
				else
					LdacR <= LdacR; SdacR <= SdacR; 
					Aflg <= Aflg; LifL <= LifL;
				end if;
			else
				LdacR <= LdacR; SdacR <= SdacR;
				Aflg <= Aflg; LifL <= LifL;
			end if;
		end if;
	end process;
	
	DacR(15 downto 1) <= LdacR(15 downto 1); DacR(0) <= '0';
	DacL(0) <= '0'; DacL(15 downto 1) <= LdacL;
	MacR <= SdacR;  MacL(15 downto 1) <= SdacL; MacL(0) <= '0';
	NacR <= LifR;   NacL(15 downto 1) <= LifL;  NacL(0) <= '0';
	Smeter <= Smet; Flags(15 downto 1) <= Aflg; Flags(0) <= '0';

	--Debug <= LdacR(0);
	Debug <= RecP(0);

END one;

