--/////////////////////////////////////////////////////////////////////////////
--		TRX305MB FPGA main (C)Copyright 2014 AOR LTD
--						issue 2014,10,15
--							by Y nishimura
--/////////////////////////////////////////////////////////////////////////////
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity main is
	port
		(
			Tfs			: in  std_logic;	-- 1pin "SER8"
			Tsc			: out std_logic;	-- 2pin "SER7"
			OfdmRec		: out std_logic;	-- 3pin
			Sbus6		: inout std_logic;  -- 4pin CPU bus
			Sbus7		: inout std_logic;	-- 6pin CPU bus
			Sbus8		: inout std_logic;	-- 7pin CPU bus
			Sbus9		: inout std_logic;	-- 8pin CPU bus
			Sbus10		: inout std_logic;	-- 10pin CPU bus
			Sbus11		: inout std_logic;	-- 11pin CPU bus
			Dt0Pri		: in  std_logic;	-- 22pin DSP "SERB3"
			Dt1Pri		: in  std_logic;	-- 23pin DSP "SERB2"
			CodecTx		: in  std_logic;	-- 24pin SDO/AD73311
			Clk65MHz	: in  std_logic;	-- 25pin Digital signal procecssing 65MHz
			OfdmTxd		: in  std_logic;	-- 28pin
			ADCof		: in  std_logic;	-- 30pin ADC over flow
			ADC13		: in  std_logic;	-- 31pin ADC bus13
			ADC12		: in  std_logic;	-- 32pin ADC bus12
			ADC11		: in  std_logic;	-- 33pin ADC bus11
			ADC10		: in  std_logic;	-- 34pin ADC bus10
			ADC9		: in  std_logic;	-- 38pin ADC bus9
			ADC8		: in  std_logic;	-- 39pin ADC bus8
			ADC7		: in  std_logic;	-- 42pin ADC bus7
			ADC6		: in  std_logic;	-- 43pin ADC bus6
			ADC5		: in  std_logic;	-- 44pin ADC bus5
			ADC4		: in  std_logic;	-- 46pin ADC bus4
			ADC3		: in  std_logic;	-- 49pin ADC bus3
			ADC2		: in  std_logic;	-- 50pin ADC bus2
			ADC1		: in  std_logic;	-- 51pin ADC bus1
			ADC0		: in  std_logic;	-- 52pin ADC bus0
			DACCLK		: out std_logic;	-- 54pin DAC clock
			Add0		: in  std_logic;	-- 55pin CPU address1
			Add1		: in  std_logic;	-- 58pin CPU address2
			Add2		: in  std_logic;	-- 59pin CPU address3
			DDbus4		: out std_logic;	-- 60pin DDS bus4 "DDSS9"
			DDbus3		: out std_logic;	-- 64pin DDS bus3 "DDSS8"
			DDbus2		: out std_logic;	-- 65pin DDS bus2 "DDSS7"
			DDbus1		: out std_logic;	-- 66pin DDS bus1 "DDSS6"
			Sdo			: in  std_logic;	-- 67pin DDS SDO  "DDSS2"
			DDbus0		: out std_logic;	-- 68pin DDS bus0 "DDSS5"
			IoUpdate	: out std_logic;	-- 69pin DDS I/Q update "DDSS4"
			Sclk		: out std_logic;	-- 70pin DDS S Cloc "DDSS1"
			IoReset		: out std_logic;	-- 71pin DDS I/O reset "DDSS0"
			Sdio		: out std_logic;	-- 72pin DDS SDIO "DDSS3"
			Add3		: in  std_logic;	-- 73pin CPU address4
			PllDa65		: out std_logic;	-- 74pin 65MHz PLL datfa
			Adclk		: out std_logic;	-- 75pin 65MHz/4=12.25MHz
			Int			: out std_logic;	-- 76pin for CPU PB4 20kHz Interrupt
			DACLRC		: out std_logic;	-- 77pin DAC LRC 
			PllLe65		: out std_logic;	-- 79pin 65MHz PLL Latch Enable
			PllClk65	: out std_logic;	-- 80pin 65MHz PLL Clock 
			Dr1Pri		: out std_logic;	-- 83pin DSP Txdata "SER5"
			Sbus13		: inout std_logic;	-- 84pin CPU bus13
			Sbus14		: inout std_logic;	-- 85pin CPU bus14
			Sbus12		: inout std_logic;	-- 86pin CPU bus12
			Strob		: in  std_logic;	-- 87pin SDIFS/AD73311
			Csb			: in  std_logic;	-- 88pin CPU Chip select2
			Rd			: in  std_logic;	-- 89pin CPU Read Enable
			Wrl			: in  std_logic;	-- 90pin CPU Write Enable
			MasterClk	: in  std_logic;	-- 91pin Master clock 40MHz
			CodecRx		: out std_logic;	-- 98pin SDI.AD73311
			PllDa1G		: out std_logic;	-- 99pin 1GHz Pll data "PL2"
			PllLe1G		: out std_logic;	-- 100pin 1GHz Pll Latch Enable "PL1"
			PllMux		: in  std_logic;	-- 101pin 1GHz Pll Mux data input "PL0"
			Sbus15		: inout std_logic;	-- 103pin CPU bus15
			PllClk1G	: out std_logic;	-- 104pin 1GHz Pll Clock "PL3"
			Sbus4		: inout std_logic;	-- 105pin CPU bus4
			Sbus1		: inout std_logic;	-- 106pin CPU bus1
			Sbus0		: inout std_logic;	-- 110pin CPU bus0
			Sbus2		: inout	std_logic;	-- 111pin CPU bus2
			Sbus5		: inout std_logic;	-- 112pin CPU bus5
			Sbus3		: inout std_logic;	-- 113pin CPU bus3
			Dr0Sec		: out std_logic;	-- 114pin DSP serial data out "SERB1"
			Dt0Sec		: in  std_logic;	-- 115pin DSP serial data in  "SERB4"
			Dr0Pri		: out std_logic;	-- 119pin DSP serial data out "SERB0"
			DDbus17		: out std_logic;	-- 120pin DDS bus17 "DDSS24"
			DDbus16		: out std_logic;	-- 121pin DDS bus16 "DDSS23"
			DDbus15		: out std_logic;	-- 124pin DDS bus15 "DDSS22"
			DDbus14		: out std_logic;	-- 125pin DDS bus14 "DDSS21"
			DDbus13		: out std_logic;	-- 126pin DDS bus13 "DDSS20"
			DDbus12		: out std_logic;	-- 127pin DDS bus12 "DDSS19"
			DDbus11		: out std_logic;	-- 128pin DDS bus11 "DDSS18"
			DDbus10		: out std_logic;	-- 129pin DDS bus10 "DDSS17"
			DDbus9		: out std_logic;	-- 132pin DDS bus9  "DDSS16"
			DDbus8		: out std_logic;	-- 133pin DDS bus8  "DDSS15"
			DDbus7		: out std_logic;	-- 135pin DDS bus7	"DDSS14"
			DDbus6		: out std_logic;	-- 136pin DDS bus6  "DDSS13"
			PDclk		: in  std_logic;	-- 137pin DDS bus clock "DDSS12"
			CodeClk		: in  std_logic;	-- 138pin Sclk/AD73311
			DACDAT		: out std_logic;	-- 141pin DDS Tx enable "DDSS11"
			DDbus5		: out std_logic;	-- 142pin DDS bus5	"DDSS10"
			Dr1Sec		: out std_logic;	-- 143pin DSP serial out "SERB6"
			Rfso		: out std_logic		-- 144pin DSP flag "SERB9"
		);
end main;

architecture Behavioral of main is
	signal	DDfreq					: std_logic_vector(28 downto 0);
	signal	Idata,Qdata				: std_logic_vector(27 downto 0);
	signal	Frequency				: std_logic_vector(25 downto 0);
	signal	DDSbus,TxI,TxQ			: std_logic_vector(17 downto 0);
	signal	OutIf,OutQf				: std_logic_vector(17 downto 0);
	signal	SHbusI,Ifshift,Smeter	: std_logic_vector(15 downto 0);
	signal	Flags,DacR,DacL,MacL	: std_logic_vector(15 downto 0);
	signal	MacR,NacL,NacR,Adco		: std_logic_vector(15 downto 0);
	signal	PPTcnt					: std_logic_vector(15 downto 0);
	signal	HighFreq,Rfs,SHbus,DDfH	: std_logic_vector(15 downto 0);
	signal	CWpitch					: std_logic_vector(15 downto 0);
	signal	Cntsw					: std_logic_vector(14 downto 0);
	signal	Adcd					: std_logic_vector(13 downto 0);
	signal	Intcnt,Gate78cnt		: std_logic_vector(8 downto 0);
	signal	Beep,AMmod,OutGain		: std_logic_vector(7 downto 0);
	signal	ALCcont					: std_logic_VEctor(6 downto 0);
	signal	HFmode					: std_logic_vector(5 downto 0);
	signal	SHadd,DSPadd,OutEx		: std_logic_vector(3 downto 0);
	signal	BeepVol					: std_logic_vector(2 downto 0);
	signal	Dcnt1,Dcnt2				: std_logic_vector(2 downto 0);
	signal	Clkcnt					: std_logic_vector(1 downto 0);
	signal	Hfil,SSBmode,Cdown,Csta	: std_logic_vector(1 downto 0);
	signal	Reset,Busy1G,Int1G,ttt	: std_logic;
	signal	Trig65,Busy65,RstCIC	: std_logic;
	signal	TxGate,DacLp,Lload,Dwen	: std_logic;
	signal	Mute,Adload,DDStrig		: std_logic;
	signal	Ptt,Trigb,Errorb		: std_logic;
	signal	SHbusEN,Dvol,Cwen,Dgate	: std_logic;
	signal	Sgate,Test,Teep,Tepa	: std_logic;
	signal	CWkey,Ugate,Dum,TRXmod	: std_logic;
	signal	Hetero,ResetDD,Tmute	: std_logic;
	signal	InPDC,CWtx,CWmod,Gate31	: std_logic;
	signal	Intsub,Wide,Fgate		: std_logic;
	signal	AdcSamp,Pgate,Ck10,Stxd	: std_logic;
	signal	Pttp					: std_logic;
	signal	NClk,Gate78K			: std_logic;
	signal	DebugCodec,DebugTwo,Temp: std_logic;

	component PLLIC is
		port
			(
				Hclk		: in  std_logic;	-- Master clock
				Reset		: in  std_logic;	-- Master Reset
				Cgate		: in  std_logic;	-- Low clock
				Plllock		: in  std_logic;	-- PLL lock signal
				SCLK		: out std_logic;	-- PLL Serial clock
				DATA		: out std_logic;	-- PLL data
				BUSY		: out std_logic;	-- Data busy
				LE			: out std_logic;	-- PLL Latch enable
				Intp		: out std_logic;	-- PLL intial set mode
				Clk10MHz	: out std_logic;	-- 10MHz out
				Pll65trig	: out std_logic		-- PLL 250MHz Trigger enable
			);
	end component;

	component PLLIC65 is
		port
			(
				Hclk		: in  std_logic;	-- Master clock
				Reset		: in  std_logic;	-- Master Reset
				Cgate		: in  std_logic;	-- Slow clock
				Dgate		: in  std_logic;	-- Very Slow clock gate
				Trig		: in  std_logic;	-- PLL set Trigger
				SCLK		: out std_logic;	-- PLL Serial clock
				DATA		: out std_logic;	-- PLL data
				BUSY		: out std_logic;	-- Data busy
				LE			: out std_logic		-- PLL Latch enable
			);
	end component;
	
	component HFMODMAIN is
		port (
				Reset	  	: in	std_logic;			-- Master Reset
				Clk65R0	  	: in	std_logic;			-- 65MHz clock
				Ptt			: in  	std_logic;	-- PTT mode
				ADC	  		: in	std_logic_vector(13 downto 0);	-- ADC input
				HFfreq	  	: in	std_logic_vector(25 downto 0);	-- HF receiving freq.
				IFshift	  	: in	std_logic_vector(15 downto 0);	-- IF shift freq.
				HFfil	  	: in	std_logic_vector(1 downto 0);
				SSBmode	  	: in	std_logic_vector(1 downto 0);	-- 00:AM  01:LSB  10:USB 11:CW
				DataI		: out   std_logic_vector(27 downto 0);
				DataQ 		: out   std_logic_vector(27 downto 0);
				Cdown		: out	std_logic_vector(1 downto 0);
				OutEx		: out 	std_logic_vector(3 downto 0);
				OutIf		: out 	std_logic_vector(17 downto 0);
				OutQf		: out 	std_logic_vector(17 downto 0);
				Tepa		: out 	std_logic;
				Daclk		: out   std_logic;	-- DAC clock;
				Sgate		: out 	std_logic;	-- 65MHz gate
				WideM		: out	std_logic;	-- Wide Mode
				Lload		: out   std_logic
			);			-- HF I/Q data out
	end component;

	component DSPserialIFTwo is
		port
			(
				Hclk		: in  std_logic;	-- Master clock
				HHclk		: in  std_logic;	-- 65MHz clock
				Reset		: in  std_logic;	-- Master Reset
				Fgate		: in  std_logic;	-- Data Start trigger
				Wen			: in  std_logic;	-- Sh write enable
				Rfs			: in  std_logic;	-- Serial rec frame start
				Rdp			: in  std_logic;	-- Serial rec prim
				Rds			: in  std_logic;	-- Serial rec second
				Rdps		: in  std_logic;	-- 2nd serial prim line ***
				Wide		: in  std_logic;	-- 1:wide mode 0:narrow mode
				HFmode		: in  std_logic_vector(5 downto 0);  -- HFmode flag
				HFdataI		: in  std_logic_vector(15 downto 0); -- HF I data
				HFdataQ		: in  std_logic_vector(15 downto 0); -- HF Q data
				HFexp		: in  std_logic_vector(3 downto 0);  -- HF exp data
				Shadd		: in  std_logic_vector(3 downto 0);  -- Sh address
				Shdata		: in  std_logic_vector(15 downto 0); -- Sh bus
				InEx		: in  std_logic_vector(3 downto 0);  -- Wide I/Q exp
				InIf		: in  std_logic_vector(15 downto 0); -- Wide I data
				InQf		: in  std_logic_vector(15 downto 0); -- Wide Q data
				IdataSub	: in  std_logic_vector(27 downto 0); -- I data input
				QdataSub	: in  std_logic_vector(27 downto 0); -- Q data input
				Foffset		: in  std_logic_vector(19 downto 0); -- Frequency Offset
				Cgate		: out std_logic;	-- Clock gate for PLL
				Tclk		: out std_logic;	-- Serial Transmit clock
				Tfs			: out std_logic;	-- Serial Transmit Frame start
				Tdp			: out std_logic;	-- Primary data out channel 0
				Tds			: out std_logic;	-- secondry data out channel 0
				TdpSub		: out std_logic;	-- Primary data out channel 1
				TdsSub		: out std_logic;	-- secondry data out channel 1
				DacLoad		: out std_logic;
				DacR		: out std_logic_vector(15 downto 0);
				DacL		: out std_logic_vector(15 downto 0);
				MacR		: out std_logic_vector(15 downto 0);
				MacL		: out std_logic_vector(15 downto 0);
				NacR		: out std_logic_vector(15 downto 0);
				NacL		: out std_logic_vector(15 downto 0);
				Smeter		: out std_logic_vector(15 downto 0);
				Flags		: out std_logic_vector(15 downto 0);
				Tepa		: out std_logic;
				FixI		: in  std_logic_vector(27 downto 0);
				FixQ		: in  std_logic_vector(27 downto 0);
				Debug		: out std_logic
			);
	end component;

	component codec is
		port
			(
				Mclk		: in	std_logic;	-- Master clock  40MHz
				Clk65Mhz	: in    std_logic;	-- 65MHz clock
				Reset		: in	std_logic;	-- Master Reset
				Gate63k		: in    std_logic;	-- 63k gate signal
				CWmode		: in	std_logic;	-- CW transmit mode
				CWkey		: in    std_logic;	-- CW key in
				CWpitch		: in	std_logic_vector(15 downto 0); -- CW pitch frequency
				Mute		: in    std_logic;	-- Mute control
				Coclk		: in	std_logic;	-- Codec Clock input
				Costb		: in	std_logic;	-- Codec Strobe
				Corx		: in	std_logic;	-- Codec RX data
				Dvol		: in    std_logic;  -- Volume control enable
				Dwen		: in	std_logic;	-- DAC data Write enable
				Beep		: in    std_logic_vector(7 downto 0);
				Idata		: in	std_logic_vector(15 downto 0);  -- DAC input
				DacLoad		: in	std_logic;	-- DAC load timing
				DAdata		: in    std_logic_vector(15 downto 0);
				Adload		: out	std_logic;	-- Adc load timing
				Adcout		: out	std_logic_vector(15 downto 0);
				Dout		: out	std_logic;	-- Codec data out
				LRCK		: out 	std_logic;  -- Left/Right pulse
				BCLK		: out 	std_logic;  -- Base clock
				Sdata		: out 	std_logic;  -- Serial Out data
				AdcSamp		: out 	std_logic;	-- ADC sampling pulse
				Debug		: out 	std_logic
			);
	end component;

	component DDSser is
		port
			(
				Hclk	: in  std_logic;	-- Master clock
				Reset	: in  std_logic;	-- Master Reset
				Trig	: in  std_logic;	-- PLL set Trigger
				Ptt		: in  std_logic;	-- PTT 1=TX  0=RX
				TRXmode	: in  std_logic;	-- TRX mode for testting
				Hetero	: in  std_logic;	-- Heterodyne mode
				Frequency : in  std_logic_vector(28 downto 0); -- Input data
				OutGain	: in  std_logic_vector(7 downto 0);	-- Output Gain
				SCLK	: out std_logic;	-- PLL Serial clock
				DATA	: out std_logic;	-- PLL data
				IOupdate : out std_logic;	-- End of job
				LE		: out std_logic		-- PLL Latch enable
			);
	end component;

	component RtimeClock is
		port
			(
				Hclk		: in  std_logic;	-- Master 36MHz clock
				Reset		: in  std_logic;	-- Master Reset
				Trigb		: in  std_logic;	-- Beep trigger
				Errorb		: in  std_logic;	-- Error Beep
				BeepVol		: in  std_logic_vector(2 downto 0); -- Beep Volume
				Pgate		: out std_logic;	-- Slow gate
				Beep		: out std_logic_vector(7 downto 0)	-- Beep sound
			);
	end component;

	component shifwr is
		port
			(
				Mclk		: in  std_logic;	-- Master clock
				Reset		: in  std_logic;	-- Master Reset
				shadd		: in  std_logic_vector(3 downto 0);  -- SH address
				shwr		: in  std_logic;	-- SH bus control
				shcs		: in  std_logic;	-- SH chip select
				Busin		: in  std_logic_vector(15 downto 0); -- SH bus input
				Cntsw		: out std_logic_vector(14 downto 0); -- internal switchs
				CWmode		: out std_logic;
				TRXmode		: out std_logic;	-- TRX mode for testting
				Hetero		: out std_logic;	-- Heterodyne mode for REC
				DDStrig		: out std_logic;	-- DDS trigger
				Trigb		: out std_logic;	-- Beep trigger
				Errorb		: out std_logic;	-- Error beep sound selected
				Volctr		: out std_logic;
				Dacen		: out std_logic;
				DSPpara		: out std_logic;	-- Load DSP parameter
				Mreset		: out std_logic;	-- Master Reset
				BeepVol		: out std_logic_vector(2 downto 0);
				CWpitch		: out std_logic_vector(15 downto 0); -- CW pitch frequency
				Frequency	: out std_logic_vector(15 downto 0); -- DDS Frequency
				IFshift		: out std_logic_vector(15 downto 0); -- IF shift frequency
				HighFreq	: out std_logic_vector(15 downto 0); -- DDS Higher Frequecny
				MfreqL		: out std_logic_vector(15 downto 0); -- Main lower frequency
				MfreqH		: out std_logic_vector(9 downto 0); -- Main higher frequency
				OutGain		: out std_logic_vector(7 downto 0); -- DDS output gain control
				DSPadd		: out std_logic_vector(3 downto 0) -- DSP parameter address
			);
	end component;

	component shifrd is
		port
			(
				Hclk		: in  std_logic;	-- 36MHz
				Reset		: in  std_logic;	-- Master Reset
				shadd		: in  std_logic_vector(3 downto 0);  -- SH address
				shrd		: in  std_logic;	-- SH bus control
				shcs		: in  std_logic;	-- SH chip select
				Dacdata		: in  std_logic_vector(15 downto 0); -- USB EP2 data
				RFlags		: in  std_logic_vector(15 downto 0); -- Flags
				Smeter		: in  std_logic_vector(15 downto 0); -- Smeter
				DSPflags	: in  std_logic_vector(15 downto 0); -- DSP flags
				RstOUT		: out std_logic;	-- System Reset out
				SHbusEN		: out std_logic;	-- SH bus enable signal
				Busout		: out std_logic_vector(15 downto 0)  -- SH bus output
			);
	end component;

	component TransmitTotal
		port
			(
				Hclk		: in  std_logic;	-- Master 4fsc clock
				Reset		: in  std_logic;	-- Master Reset
				Ptt			: in  std_logic;	-- Ptt
				TRXmode		: in  std_logic;	-- Test TRX mode
				AdcSamp		: in  std_logic;	-- ADC sampling clock
				RstCIC		: in  std_logic;	-- Reset CIC fitler reg.
				PDclk		: in  std_logic;	-- I/Q clock from AD9957
				Test		: in  std_logic;	-- 1kHz Test signal input
				CWkey		: in  std_logic;	-- CW key input
				ALCcon		: in  std_logic_vector(2 downto 0);	-- ALC control
				Ifband		: in  std_logic_vector(1 downto 0);	-- Filter band choice
				SSBmode		: in  std_logic_vector(1 downto 0);	-- 00:AM 01:LSB  10:USB 11:CW
				Indata		: in  std_logic_vector(15 downto 0); -- MIC input
				Amod		: in  std_logic_vector(7 downto 0);  -- AM modulation
				ALCcont		: out std_logic_vector(6 downto 0);
				Dgate		: out std_logic;	-- Output Sampling gate
				Pulse		: out std_logic;
				CWmod		: out std_logic;
				Gate31		: out std_logic;	-- 31kHz sample gate
				IQout		: out std_logic_vector(17 downto 0)	-- I/Q out
			);
	end component;

	component Uarttx
		port
			(
				Mclk		: in	std_logic;	-- Master clock 65MHz
				Reset		: in	std_logic;	-- Master Reset
				Wide		: in	std_logic;	-- Wide IF mode
				Dgate		: in	std_logic;	-- I/Q sampling gate
				Idata		: in	std_logic_vector(17 downto 0);
				Qdata		: in	std_logic_vector(17 downto 0);
				Exdat		: in	std_logic_vector(3 downto 0);
				Txd			: out	std_logic	-- TX out
			);
	end component;
	
begin
--	Adclk <= Cdown(1);
	Adclk <= Ck10;
--	Adclk <= Nclk;

	OfdmRec <= Stxd;  -- Test
--	OfdmRec <= Sgate; 
--	OfdmRec <= Gate31;
--	OfdmRec <= Dt0Pri;
--	OfdmRec <= DebugTwo;
--	OfdmRec <= DebugCodec;
	
-------------------------------------------------------------------------------
--	Clock 8.125MHz 2021/10 ikeda
-------------------------------------------------------------------------------
	process(Clk65MHz,Reset)
	begin
		if Reset = '0' then 
			Clkcnt <= "00"; Nclk <= '0';
		elsif rising_edge(Clk65MHz) then
			if Clkcnt = "11" then
				Nclk <= not Nclk;
			end if;
			Clkcnt <= Clkcnt + 1;
		end if;
	end process;

-------------------------------------------------------------------------------
--	Gate 78.125KHz 2023/02 ikeda
-------------------------------------------------------------------------------
	process(MasterClk,Reset)
	begin
		if Reset = '0' then 
			Gate78cnt <= "000000000"; Gate78K <= '0';
		elsif rising_edge(MasterClk) then
			if Gate78cnt = "100000000" then
				Gate78K <= '1';
			else
				Gate78K <= '0';
			end if;
			Gate78cnt <= Gate78cnt + 1;
		end if;
	end process;

-----------------------------------------------------------------------------------
--		Banding for ADC bus and SH bus
-----------------------------------------------------------------------------------
	DDbus17 <= DDSbus(17); DDbus16 <= DDSbus(16); DDbus15 <= DDSbus(15);
	DDbus14 <= DDSbus(14); DDbus13 <= DDSbus(13); DDbus12 <= DDSbus(12);
	DDbus11 <= DDSbus(11); DDbus10 <= DDSbus(10); DDbus9  <= DDSbus(9);
	DDbus8  <= DDSbus(8);  DDbus7  <= DDSbus(7);  DDbus6  <= DDSbus(6);
	DDbus5  <= DDSbus(5);  DDbus4  <= DDSbus(4);  DDbus3  <= DDSbus(3);
	DDbus2  <= DDSbus(2);  DDbus1  <= DDSbus(1);  DDbus0  <= DDSbus(0);
	
	SHbusI(15) <= Sbus15; SHbusI(14) <= Sbus14; SHbusI(13) <= Sbus13;
	SHbusI(12) <= Sbus12; SHbusI(11) <= Sbus11; SHbusI(10) <= Sbus10;
	SHbusI(9)  <= Sbus9;  SHbusI(8)  <= Sbus8;  SHbusI(7)  <= Sbus7;
	SHbusI(6)  <= Sbus6;  SHbusI(5)  <= Sbus5;  SHbusI(4)  <= Sbus4;
	SHbusI(3)  <= Sbus3;  SHbusI(2)  <= Sbus2;  SHbusI(1)  <= Sbus1;
	SHbusI(0)  <= Sbus0;

	Adcd(13) <= ADC13; Adcd(12) <= ADC12; Adcd(11) <= ADC11;
	Adcd(10) <= ADC10; Adcd(9)  <= ADC9;  Adcd(8)  <= ADC8;
	Adcd(7)  <= ADC7;  Adcd(6)  <= ADC6;  Adcd(5)  <= ADC5;
	Adcd(4)  <= ADC4;  Adcd(3)  <= ADC3;  Adcd(2)  <= ADC2;
	Adcd(1)  <= ADC1;  Adcd(0)  <= ADC0;
	
	SHadd(3) <= Add3; SHadd(2) <= Add2; SHadd(1) <= Add1; SHadd(0) <= Add0;
	
------------------------------------------------------------------------------------
--		PLL 1GHz for DDS clock
------------------------------------------------------------------------------------
	U1: PLLIC port map
			(
				Hclk		=> MasterClk,	-- Master clock
				Reset		=> Reset,		-- Master 
				Cgate		=> Sgate,		-- Low clock
				Plllock		=> PllMux,		-- PLL lock signal
				SCLK		=> PllClk1G,	-- PLL Serial clock
				DATA		=> PllDa1G,		-- PLL data
				BUSY		=> Busy1G,		-- Data busy
				LE			=> PllLe1G,		-- PLL Latch enable
				Intp		=> Int1G,		-- PLL intial set mode
				Clk10MHz	=> Ck10,		-- 10MHz out
				Pll65trig	=> Trig65		-- PLL 250MHz Trigger enable
			);

------------------------------------------------------------------------------------
--		PLL 65MHz for ADC clock
------------------------------------------------------------------------------------
	U2: PLLIC65 port map
			(
				Hclk		=> MasterClk,	-- Master clock
				Reset		=> Reset,		-- Master Reset
				Cgate		=> Sgate,		-- Slow clock
				Dgate		=> Pgate,		-- Very Slow clock gate
				Trig		=> Busy1G,		-- PLL set Trigger
				SCLK		=> PllClk65,	-- PLL Serial clock
				DATA		=> PllDa65,		-- PLL data
				BUSY		=> Busy65,		-- Data busy
				LE			=> PllLe65		-- PLL Latch enable
			);

------------------------------------------------------------------------------------
--		65MHzADC data -> Mixer to zero -> CIC -> DownSample -> FIR-> (31.73828kHz sample)
------------------------------------------------------------------------------------
	U3: HFMODMAIN port map
			(
				Reset	  	=> Reset,		-- Master Reset
				Clk65R0	  	=> Clk65MHz,	-- 65MHz clock
				Ptt			=> Ptt,			-- PTT mode
				ADC	  		=> Adcd,		-- ADC input
				HFfreq	  	=> Frequency,	-- Receiving freq.
				IFshift	  	=> Ifshift,		-- IF shift freq.
				HFfil	  	=> Hfil,		-- IF Filter Select
				SSBmode	  	=> SSBmode,		-- 00:AM  01:LSB  10:USB 11:CW
				DataI		=> Idata,		-- I data out
				DataQ 		=> Qdata,		-- Q data out
				Cdown		=> Cdown,
				OutEx		=> OutEx,		-- Exponent for Wide FM I/Q
				OutIf		=> OutIf,		-- Floating point I out for Wide FM
				OutQf		=> OutQf,		-- Floating point Q out for Wide FM
				Tepa		=> Tepa,
				Daclk		=> Ugate,		-- DAC clock;
				Sgate		=> Fgate,		-- Trigger for sending data to DSP
				WideM 		=> Wide,		-- 1:Wide FM mode 0:Normal
				Lload		=> Lload		-- Interrupt timing
			);			


-------------------------------------------------------------------------------------
--		I/Q data output
-------------------------------------------------------------------------------------
	U12: Uarttx port map
			(
				Mclk		=> Clk65MHz,	-- Master clock 65MHz
				Reset		=> Reset,		-- Master Reset
				Wide		=> Wide,		-- Wide IF mode
				Dgate		=> Fgate,		-- I/Q sampling gate
				Idata		=> OutIf,
				Qdata		=> OutQf,
				Exdat		=> OutEx,
				Txd			=> Stxd			-- TX out
			);

------------------------------------------------------------------------------------------
--		Making Inperrupt pulse for SH2
-------------------------------------------------------------------------------------------
	process(MasterClk,Reset)
	begin
		if Reset = '0'	then Intcnt <= "000000000";
		elsif Rising_edge(MasterClk) then
			if Lload = '1'			then Intcnt <= "000000000";
			else
				if Intcnt(8) = '1'	then Intcnt <= "100000000";
									else Intcnt <= Intcnt + 1;
				end if;
			end if;
		end if;
	end process;
	
	process(PDclk,Reset)
	begin
		if Reset = '0'	then Intsub <= '0';
		elsif Rising_edge(PDclk) then
			Intsub <= Intcnt(8);
		end if;
	end process;
	
	process(Intsub,Intcnt)
	begin
		if Ptt = '1' 	then Int <= Intsub;
						else Int <= Intcnt(8);
		end if;
	end process;
	
------------------------------------------------------------------------------------
--		Transmitting process
--			Modulation and oversampling to AD9957
------------------------------------------------------------------------------------
	U11: TransmitTotal port map
			(
				Hclk		=> Clk65MHz,	-- Master clock
				Reset		=> Reset,		-- Master Reset
				Ptt			=> Ptt,			-- Tx:1
				TRXmode		=> TRXmod,		-- Test TRX mode
				AdcSamp		=> AdcSamp,		-- ADC sampling clock
				RstCIC		=> RstCIC,		-- Reset CIC fitler reg.
				PDclk		=> PDclk,		-- I/Q clock from AD9957
				Test		=> Test,		-- 1:1kHz Test signal input
				CWkey		=> CWkey,		-- CW key input
				ALCcon		=> HighFreq(15 downto 13),	-- ALC control
				Ifband		=> Hfil,		-- Filter band choice
				SSBmode		=> SSBmode,		-- 00:AM 01:LSB  10:USB 11:CW
				Indata		=> Adco,		-- MIC input
				Amod		=> AMmod,		-- AM modulation
				ALCcont		=> ALCcont,
				Dgate		=> Dgate,		-- Output Sampling gate
				Pulse		=> InPDC,
				CWmod		=> CWmod,
				Gate31		=> Gate31,		-- 31kHz sample gate
				IQout		=> DDSbus		-- I/Q out
			);
			
------------------------------------------------------------------------------------
--		PTT timing process
------------------------------------------------------------------------------------
	process(Clk65MHz,Reset)
	begin
		if Reset = '0'	then
			RstCIC <= '0'; Teep <= '0'; Ptt <= '0'; Csta <= "00";
		elsif Rising_edge(Clk65MHz) then
			case Csta is
				when "00" => if Pttp = '1'		then Csta <= "01";
							 else
								if TRXmod = '1'	then Csta <= "01";
												else Csta <= "00";
								end if;
							 end if;
				when "01" => Csta <= "11";
				when "10" => Csta <= "00";
				when "11" => if (Pttp = '0') and (TRXmod = '0')	then Csta <= "10";
																else Csta <= "11";
							 end if;
				when others => Csta <= "00";
			end case;
			if Csta = "00"	then Ptt <= '0';
							else Ptt <= '1';
			end if;
			if Csta = "01"	then RstCIC <= '0';
							else RstCIC <= '1';
			end if;
--			if Csta = "11"	then Ptt <= '0';	--2021/09 ikeda
--			end if;								--PTT off ADX enable

			if Dgate = '1'	then Teep <= not Teep;
							else Teep <= Teep;
			end if;
		end if;
	end process;

	CWtx <= CWmod and Ptt;
	
------------------------------------------------------------------------------------
--		DSP communication interface
------------------------------------------------------------------------------------
	HFmode(5 downto 4) <= "00";
	HFmode(3 downto 2) <= Hfil;
	HFmode(1 downto 0) <= SSBmode;
	U5: DSPserialIFTwo port map
			(
				Hclk		=> MasterClk,	-- Master clock
				HHclk		=> Clk65MHz,	-- 65MHz clock
				Reset		=> Reset,		-- Master Reset
				Fgate		=> Fgate,		-- Data Start trigger
				Wen			=> Dwen,		-- Sh write enable
				Rfs			=> Tfs,			-- Serial rec frame start
				Rdp			=> Dt0Pri,		-- Serial rec prim
				Rds			=> Dt0Sec,		-- Serial rec second
				Rdps		=> Dt1Pri,		-- 2nd serial prim line ***
				Wide		=> Wide,		-- 1:wide mode 0:narrow mode
				HFmode		=> HFmode,		-- HFmode flag
				HFdataI		=> "0000000000000000",	-- HF I data
				HFdataQ		=> "0000000000000000",	-- HF Q data
				HFexp		=> "0000",		-- HF exp data
				Shadd		=> DSPadd,		-- Sh address
				Shdata		=> SHbusI,		-- Sh bus
				InEx		=> OutEx,		-- Wide I/Q exp
				InIf		=> OutIf(17 downto 2),		-- Wide I data
				InQf		=> OutQf(17 downto 2),		-- Wide Q data
				IdataSub	=> Idata,		-- I data input
				QdataSub	=> Qdata,		-- Q data input
				Foffset		=> "00000000000000000000", -- Frequency Offset
				Cgate		=> Sgate,		-- Clock gate for PLL
				Tclk		=> Tsc,			-- Serial Transmit clock
				Tfs			=> Rfso,		-- Serial Transmit Frame start
				Tdp			=> Dr0Pri,		-- Primary data out channel 0
				Tds			=> Dr0Sec,		-- secondry data out channel 0
				TdpSub		=> Dr1Pri,		-- Primary data out channel 1
				TdsSub		=> Dr1Sec,		-- secondry data out channel 1
				DacLoad		=> DacLp,		-- (*)
				DacR		=> DacR,		-- (*)
				DacL		=> DacL,		-- (*)
				MacR		=> MacR,		-- (*)
				MacL		=> MacL,		-- (*)
				NacR		=> NacR,		-- (*)
				NacL		=> NacL,		-- (*)
				Smeter		=> Smeter,		--
				Flags		=> Flags,		--
				Tepa		=> Dum,
				FixI		=> Idata,
				FixQ		=> Qdata,
				Debug		=> DebugTwo
			);

------------------------------------------------------------------------------------
--		ADC and DAC interface
------------------------------------------------------------------------------------
	U6: codec port map
			(
				Mclk		=> MasterClk,	-- Master clock  40MHz
				Clk65Mhz	=> Clk65MHz,	-- 65MHz clock
				Reset		=> Reset,		-- Master Reset
				Gate63k		=> Ugate,		-- 63k gate signal
				CWmode		=> CWtx,		-- CW transmit mode
				CWkey		=> CWkey,		-- CW key in
				CWpitch		=> CWpitch,		-- CW pitch frequency
				Mute		=> Tmute,		-- Mute control
				Coclk		=> CodeClk,		-- Codec Clock input
				Costb		=> Strob,		-- Codec Strobe
				Corx		=> CodecTx,		-- Codec RX data
				Dvol		=> Dvol,		-- Volume control enable
				Dwen		=> Cwen,		-- DAC data Write enable
				Beep		=> Beep,		-- Beep data
				Idata		=> SHbusI,		-- DAC input
				DacLoad		=> DacLp,		-- DacLoad timing
				DAdata		=> DacR,		-- Decode data modified
				Adload		=> Adload,		-- Adc load timing(*)
				Adcout		=> Adco,		-- 
				Dout		=> CodecRx,		-- Codec data out
				LRCK		=> DACLRC,		-- Left/Right pulse
				BCLK		=> DACCLK,		-- Base clock
				Sdata		=> DACDAT,		-- Serial Out data
				AdcSamp		=> AdcSamp,		-- ADC sampling pulse
				Debug		=> DebugCodec
			);

------------------------------------------------------------------------------------
--		AD9957 setting
------------------------------------------------------------------------------------
	U7: DDSser port map
			(
				Hclk		=> MasterClk,	-- Master clock
				Reset		=> Reset,		-- Master Reset
				Trig		=> DDStrig,		-- PLL set Trigger
				Ptt			=> Ptt,			-- PTT 1=TX  0=RX 
				TRXmode		=> TRXmod,		-- TRX mode for testting
				Hetero		=> Hetero,		-- Heterodyne mode
				Frequency 	=> DDfreq,		-- Input data
				OutGain		=> OutGain,		-- Output Gain
				SCLK		=> Sclk,		-- PLL Serial clock
				DATA		=> Sdio,		-- PLL data
				IOupdate 	=> IoUpdate,	-- End of job
				LE			=> IoReset		-- PLL Latch enable
			);

-------------------------------------------------------------------------------------
--		Beep signal generator for the "B" kit panel
-------------------------------------------------------------------------------------
	U8: RtimeClock port map
			(
				Hclk		=> MasterClk,	-- Master 40MHz clock
				Reset		=> Reset,		-- Master Reset
				Trigb		=> Trigb,		-- Beep trigger
				Errorb		=> Errorb,		-- Error Beep
				BeepVol		=> BeepVol,		-- Beep Volume
				Pgate		=> Pgate,		-- Slow gate
				Beep		=> Beep			-- Beep sound
			);

-------------------------------------------------------------------------------------
--		SH write interface
-------------------------------------------------------------------------------------
	U9: shifwr port map
			(
				Mclk		=> MasterClk,	-- Master clock
				Reset		=> Reset,		-- Master Reset
				shadd		=> SHadd,		-- SH address
				shwr		=> Wrl,			-- SH bus control
				shcs		=> Csb,			-- SH chip select
				Busin		=> SHbusI,		-- SH bus input
				Cntsw		=> Cntsw,		-- internal switchs(*)
				CWmode		=> CWkey,
				TRXmode		=> TRXmod,		-- TRX mode for testting
				Hetero		=> Hetero,		-- Heterodyne mode for REC
				DDStrig		=> DDStrig,		-- DDS trigger
				Trigb		=> Trigb,		-- Beep trigger
				Errorb		=> Errorb,		-- Error beep sound selected
				Volctr		=> Dvol,		-- Volume data load enable
				Dacen		=> Cwen,		-- Codec control data enable
				DSPpara		=> Dwen,		-- Load DSP parameter
				Mreset		=> Reset,		-- Master Reset
				BeepVol		=> BeepVol,		-- Beep Volume control
				CWpitch		=> CWpitch,		-- CW pitch frequency
				Frequency	=> DDfreq(15 downto 0),	-- DDS Frequency
				IFshift		=> Ifshift,		-- IF shift frequency
				HighFreq	=> HighFreq,	-- DDS Higher Frequecny
				MfreqL		=> Frequency(15 downto 0),  -- Main lower frequency
				MfreqH		=> Frequency(25 downto 16),	-- Main higher frequency
				OutGain		=> OutGain,		-- DDS output gain control
				DSPadd		=> DSPadd		-- DSP parameter address
			);
	DDfreq(28 downto 16) <= HighFreq(12 downto 0);
	Hfil <= Cntsw(1 downto 0);
	SSBmode <= Cntsw(3 downto 2);
	Pttp <= Cntsw(4);
	Mute <= Cntsw(5);
	Test <= Cntsw(6);
	AMmod <= Cntsw(14 downto 7);

	process(MasterClk,Reset)
	begin
		if Reset = '0'	then Tmute <= '0';
		elsif Rising_edge(MasterClk) then
			if CWtx = '1'		then Tmute <= '0';
			else
				if Ptt = '1'	then Tmute <= '1';
								else Tmute <= Mute;
				end if;
			end if;
		end if;
	end process;
	
-------------------------------------------------------------------------------------
--		SHread interface
-------------------------------------------------------------------------------------
	U10: shifrd port map
			(
				Hclk		=> MasterClk,	-- 40MHz
				Reset		=> Reset,		-- Master Reset
				shadd		=> SHadd,		-- SH address
				shrd		=> Rd,			-- SH bus control
				shcs		=> Csb,			-- SH chip select
				Dacdata		=> Adco,		-- ADC data
				RFlags		=> Rfs,			-- Flags
				Smeter		=> Smeter,		-- Smeter
				DSPflags	=> Flags,		-- DSP flags
				RstOUT		=> ResetDD,		-- System Reset out
				SHbusEN		=> SHbusEN,		-- SH bus enable signal
				Busout		=> SHbus		-- SH bus output
			);

	Rfs(0) <= Busy1G;
	Rfs(1) <= Busy65;
	Rfs(2) <= Adload;
	Rfs(10 downto 4) <= ALCcont;

	process(SHbus,SHbusEN)
	begin
		if SHbusEN = '0'	then
			Sbus15 <= SHbus(15); Sbus14 <= SHbus(14); Sbus13 <= SHbus(13);
			Sbus12 <= SHbus(12); Sbus11 <= SHbus(11); Sbus10 <= SHbus(10);
			Sbus9  <= SHbus(9);  Sbus8  <= SHbus(8);  Sbus7  <= SHbus(7);
			Sbus6  <= SHbus(6);  Sbus5  <= SHbus(5);  Sbus4  <= SHbus(4);
			Sbus3  <= SHbus(3);  Sbus2  <= SHbus(2);  Sbus1  <= SHbus(1);
			Sbus0  <= SHbus(0);
		else
			Sbus15 <= 'Z'; Sbus14 <= 'Z'; Sbus13 <= 'Z';
			Sbus12 <= 'Z'; Sbus11 <= 'Z'; Sbus10 <= 'Z';
			Sbus9  <= 'Z'; Sbus8  <= 'Z'; Sbus7  <= 'Z';
			Sbus6  <= 'Z'; Sbus5  <= 'Z'; Sbus4  <= 'Z';
			Sbus3  <= 'Z'; Sbus2  <= 'Z'; Sbus1  <= 'Z';
			Sbus0  <= 'Z';
		end if;
	end process;

end Behavioral;
