-- SH-ACEX interface  ---------------------- 2005 07 01 ----- 
--  Address  InOut function                 
--    00     R/W   Control reg
--    02     R     S meter read
--    04	 R     DCS data
--	  06     R     DSP flags read
--    08     R     USB EP2 bulk data
-------------------------------------------------------------
LIBRARY ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity shifrd is
	port
		(
			Hclk		: in  std_logic;	-- 36MHz
			Reset		: in  std_logic;	-- Master Reset
			shadd		: in  std_logic_vector(3 downto 0);  -- SH address
			shrd		: in  std_logic;	-- SH bus control
			shcs		: in  std_logic;	-- SH chip select
			Dacdata		: in  std_logic_vector(15 downto 0); -- ADC data
			RFlags		: in  std_logic_vector(15 downto 0); -- Flags
			Smeter		: in  std_logic_vector(15 downto 0); -- Smeter
			DSPflags	: in  std_logic_vector(15 downto 0); -- DSP flags
			RstOUT		: out std_logic;	-- System Reset out
			SHbusEN		: out std_logic;	-- SH bus enable signal
			Busout		: out std_logic_vector(15 downto 0)  -- SH bus output
		);
end shifrd;

ARCHITECTURE one OF shifrd IS
	signal Rtca	    			: std_logic_vector(15 downto 0);
	signal Sta					: std_logic_vector(1 downto 0);
	signal Ird,Hold,LHour		: std_logic;

BEGIN
	Ird <= shcs or shrd;
	SHbusEN <= Ird;
	Rtca(15) <= '0'; Rtca(14 downto 0) <= RFlags(14 downto 0);
	
	process(Hclk)
	begin
		if rising_edge(Hclk) then
			if shadd = "1111"	then RstOUT <= Ird;
								else RstOUT <= '1';
			end if;
		end if;
	end process;

	process(Hclk,Reset)
	begin
		if Reset = '0' 		then Sta <= "00"; LHour <= '0';
		elsif rising_edge(Hclk) then
			case Sta is
				when "00" => if Ird = '0' then
								if shadd = "0101"	then Sta <= "01";
													else Sta <= "00";
								end if;
							 else Sta <= "00";
							 end if;
				when "01" => Sta <= "11";
				when "10" => if Ird = '0'			then Sta <= "10";
													else Sta <= "00";
							 end if;
				when "11" => Sta <= "10";
				when others => Sta <= "00";
			end case;
			if Sta = "01"	then LHour <= Hold;
							else LHour <= LHour;
			end if;
		end if;
	end process;

	process(shadd,Ird,Rtca,Smeter,DSPflags,Dacdata)
	begin
		if Ird = '0' then
			case shadd is
				when "0000" => Busout <= Rtca;
				when "0001" => Busout <= Smeter;
				when "0011" => Busout <= DSPflags;
				when "0100" => Busout <= Dacdata;
				when others => Busout <= Dacdata;
			end case;
		else 
			Busout <= "0000000000000000";
		end if;
	end process;
	
	
END one;

