-- SH-CycloneIII interface  -------------------------------------- 
--    00   	  Control reg
--					bit0 0/Normal Access 1/DSP access
--    02   	  AD73311 cordic control
--    04	  DSP data write
--	  06	  Main frequency low
--    08	  Beep DDS trigger + Main Frequency High
--	  0A      IF shift frequency
--	  0C   	  DDS Frequency low
--	  0E      DDS Frequency High
--    1X      DSP parameter
------------------------------------------------------------------
LIBRARY ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity shifwr is
	port
		(
			Mclk		: in  std_logic;	-- Master clock
			Reset		: in  std_logic;	-- Master Reset
			shadd		: in  std_logic_vector(3 downto 0);  -- SH address
			shwr		: in  std_logic;	-- SH bus control
			shcs		: in  std_logic;	-- SH chip select
			Busin		: in  std_logic_vector(15 downto 0); -- SH bus input
			Cntsw		: out std_logic_vector(14 downto 0); -- internal switchs
			CWmode		: out std_logic;
			TRXmode		: out std_logic;	-- TRX mode for testing
			Hetero		: out std_logic;	-- Heterodyne mode for REC
			DDStrig		: out std_logic;	-- DDS trigger
			Trigb		: out std_logic;	-- Beep trigger
			Errorb		: out std_logic;	-- Error beep sound selected
			Volctr		: out std_logic;
			Dacen		: out std_logic;
			DSPpara		: out std_logic;	-- Load DSP parameter
			Mreset		: out std_logic;	-- Master Reset
			BeepVol		: out std_logic_vector(2 downto 0);
			CWpitch		: out std_logic_vector(15 downto 0); -- CW pitch frequency
			Frequency	: out std_logic_vector(15 downto 0); -- DDS Frequency
			IFshift		: out std_logic_vector(15 downto 0); -- IF shift frequency
			HighFreq	: out std_logic_vector(15 downto 0); -- DDS Higher Frequecny
			MfreqL		: out std_logic_vector(15 downto 0); -- Main lower frequency
			MfreqH		: out std_logic_vector(9 downto 0); -- Main higher frequency
			OutGain		: out std_logic_vector(7 downto 0); -- DDS output gain control
			DSPadd		: out std_logic_vector(3 downto 0) -- DSP parameter address
		);
end shifwr;

ARCHITECTURE one OF shifwr IS
	signal Iwr,DDStri,CWm	: std_logic;
	signal Tigb,Beep,Plltri	: std_logic;
	signal Dual,Prst		: std_logic;
	signal Vol				: std_logic_vector(2 downto 0);
	signal Bee,Ogain		: std_logic_vector(7 downto 0);
	signal Dfrh				: std_logic_vector(9 downto 0);
	signal Cont,Freq,FreqH	: std_logic_vector(15 downto 0);
	signal MFreq,Dfrl,CWpi	: std_logic_vector(15 downto 0);

BEGIN
	Iwr <= shcs or shwr;
	DSPadd(3) <= Cont(0);
	DDStrig <= DDStri;
	DSPadd(2 downto 0) <= shadd(2 downto 0);
	Trigb <= Tigb; Errorb <= Beep; BeepVol <= Vol;
	OutGain <= Ogain; CWmode <= CWm; TRXmode <= Dual;
	Hetero <= Plltri; Mreset <= Prst;
-- Latch control register -------------------------------
	process(Mclk,Reset)
	begin
		if Reset = '0'	then Cont <= "0000000000000000";
		elsif Rising_edge(Mclk) then
			if (Iwr = '0') and (shadd = "0000") then
				Cont <= Busin;
			else
				Cont <= Cont;
			end if;
		end if;
	end process;
--	Cntsw <= Cont(15 downto 1); double booking

-- Beep register ------------------------------------------
	process(Mclk)
	begin
		if Rising_edge(Mclk) then
			if (Iwr = '0') and (shadd = "0100") then
				if Busin(0) = '1'	then
					Ogain <= Busin(15 downto 8);
					Dfrh <= Dfrh;
					Vol <= Busin(5 downto 3);
					Beep <= Beep; Tigb <= '0';
					CWm <= Busin(6); Dual <= Busin(7); Prst <= Prst;
					Plltri <= Busin(1); DDStri <= Busin(2);
				else
					Ogain <= Ogain; CWm <= CWm; Vol <= Vol; 
					Dfrh <= Busin(15 downto 6); Dual <= Dual;
					Plltri <= Plltri; DDStri <= '0';
					Beep <= Busin(5); Tigb <= Busin(4);
					Prst <= not Busin(3);
				end if;
			else
				Vol <= vol; Beep <= Beep; Tigb <= '0'; Ogain <= Ogain;
				Plltri <= Plltri; DDStri <= '0'; Dfrh <= Dfrh; CWm <= CWm;
				Dual <= Dual; Prst <= Prst;
			end if;
		end if;
	end process;

-- Latch Frequency register -------------------------------
	process(Mclk,Reset)
	begin
		if Reset = '0'	then Freq <= "0000000000000000";
		elsif Rising_edge(Mclk) then
			if (Iwr = '0') and (shadd = "0110") then
				Freq <= Busin;
			else
				Freq <= Freq;
			end if;
		end if;
	end process;
	
	process(Mclk,Reset)
	begin
		if Reset = '0'	then MFreq <= "0000000000000000";
		elsif Rising_edge(Mclk) then
			if (Iwr = '0') and (shadd = "0101") then
				MFreq <= Busin;
			else
				MFreq <= MFreq;
			end if;
		end if;
	end process;
	
	process(Mclk,Reset)
	begin
		if Reset = '0'	then FreqH <= "0000000000000000";
		elsif Rising_edge(Mclk) then
			if (Iwr = '0') and (shadd = "0111") then
				FreqH <= Busin;
			else
				FreqH <= FreqH;
			end if;
		end if;
	end process;

	process(Mclk,Reset)
	begin
		if Reset = '0'	then Dfrl <= "0000000000000000";
		elsif Rising_edge(Mclk) then
			if (Iwr = '0') and (shadd = "0011") then
				Dfrl <= Busin;
			else
				Dfrl <= Dfrl;
			end if;
		end if;
	end process;


	Cntsw <= Cont(15 downto 1);
	IFshift <= MFreq;
	Frequency <= Freq;
	HighFreq <= FreqH;
	MfreqL <= Dfrl;
	MfreqH <= Dfrh;

-- Address decoder for write ---------------------------------
	process(Iwr,shadd)
	begin
		if Iwr = '0' then
			if shadd = "0001"	then Dacen <= '1'; -- VGA set address
								else Dacen <= '0';
			end if;
			if shadd = "0010"	then Volctr <= '1'; -- dsp data
								else Volctr <= '0';
			end if;
			if shadd(3) = '1'	then DSPpara <= '1'; -- DSP parametere load
								else DSPpara <= '0';
			end if;
		else
			Dacen <= '0'; Volctr <= '0'; DSPpara <= '0';
		end if;
	end process;
	
-- CW pitch data lached into the register --------------------
	process(Mclk,Reset)
	begin
		if Reset = '0'	then
			CWpi <= "0000000000000000";
		elsif Rising_edge(Mclk) then
			if (Iwr = '0') and (shadd = "1110") then
				CWpi <= Busin;
			else
				CWpi <= CWpi;
			end if;
		end if;
	end process;
	CWpitch <= CWpi;

END one;

